/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api.validation;

import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public interface SchemaRequiredPropertiesValidator<A extends Annotation, T>
extends ConstraintValidator<A, T> {
    @Override
    default public boolean isValid(T data, ConstraintValidatorContext context) {
        String[] requiredProperties;
        boolean isValid = true;
        context.disableDefaultConstraintViolation();
        if (data.getClass().getAnnotation(Schema.class) != null && (requiredProperties = data.getClass().getAnnotation(Schema.class).requiredProperties()) != null) {
            for (String propName : requiredProperties) {
                try {
                    Field field = this.getFieldFromClassHierarchy(data.getClass(), propName);
                    field.setAccessible(true);
                    if (null != field.get(data)) continue;
                    isValid = false;
                    context.buildConstraintViolationWithTemplate("must not be null").addPropertyNode(propName).addConstraintViolation();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return isValid;
    }

    private Field getFieldFromClassHierarchy(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                field = this.getFieldFromClassHierarchy(clazz.getSuperclass(), fieldName);
            }
            throw e;
        }
        return field;
    }
}

