/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.errors;

import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.Reporting;
import gov.cms.fiss.pricers.common.application.errors.YearNotImplementedError;
import gov.cms.fiss.pricers.common.application.request.RequestContentExtractor;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.violations.ConstraintViolationProblem;
import org.zalando.problem.violations.Violation;

@Provider
public class YearNotImplementedExceptionMapper
implements ExceptionMapper<YearNotImplementedException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(YearNotImplementedExceptionMapper.class);
    public static final String PROBLEM_MESSAGE = "Claim year not supported: '%s'";

    @Override
    public Response toResponse(YearNotImplementedException exception) {
        YearNotImplementedError error = new YearNotImplementedError(String.format("Year Not Implemented. A value of \"%s\" was submitted for the field '%s', but the Pricer API does not yet support this year.", exception.getDate(), exception.getFieldName()));
        Reporting.reportEventToNR("YearNotImplemented", exception.getFieldName(), exception.getMessage());
        LOGGER.debug(error.getMessage());
        if (null == RequestContentExtractor.rfc7807Support()) {
            return Response.status(error.getCode()).type("application/json").entity(error).build();
        }
        return Response.status(Status.BAD_REQUEST.getStatusCode()).type("application/problem+json").entity(new ConstraintViolationProblem(Problem.DEFAULT_TYPE, Status.BAD_REQUEST, List.of(new Violation(exception.getFieldName(), String.format(PROBLEM_MESSAGE, exception.getDate()))))).build();
    }
}

