/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.ComorbidityData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ConvertComorbidityCwfReturnCode
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        ComorbidityData comorbidities = calculationContext.getComorbidities();
        if (StringUtils.isEmpty(calculationContext.getCwfReturnCode())) {
            calculationContext.setComorbidityCodes(Optional.ofNullable(comorbidities.getComorbidityCodes()).orElseGet(ArrayList::new));
        } else {
            switch (calculationContext.getCwfReturnCode()) {
                case "10": {
                    calculationContext.setCwfReturnCode(null);
                    break;
                }
                case "20": {
                    calculationContext.setComorbidityCodes(List.of("MA"));
                    calculationContext.setCwfReturnCode(null);
                    break;
                }
                case "40": {
                    calculationContext.setComorbidityCodes(List.of("MC"));
                    calculationContext.setCwfReturnCode(null);
                    break;
                }
                case "50": {
                    calculationContext.setComorbidityCodes(List.of("MD"));
                    calculationContext.setCwfReturnCode(null);
                    break;
                }
                case "60": {
                    calculationContext.setComorbidityCodes(List.of("ME"));
                    calculationContext.setCwfReturnCode(null);
                    break;
                }
            }
        }
    }
}

