/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.ConsoleAppenderFactory;
import io.dropwizard.logging.filter.NullLevelFilterFactory;
import io.dropwizard.request.logging.LogbackAccessRequestLog;
import io.dropwizard.request.logging.RequestLogFactory;
import io.dropwizard.request.logging.async.AsyncAccessEventAppenderFactory;
import io.dropwizard.request.logging.layout.LogbackAccessRequestLayoutFactory;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.RequestLog;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="logback-access")
public class LogbackAccessRequestLogFactory
implements RequestLogFactory<RequestLog> {
    @Valid
    @NotNull
    private List<AppenderFactory<IAccessEvent>> appenders = Collections.singletonList(new ConsoleAppenderFactory());

    @JsonProperty
    public List<AppenderFactory<IAccessEvent>> getAppenders() {
        return this.appenders;
    }

    @JsonProperty
    public void setAppenders(List<AppenderFactory<IAccessEvent>> appenders) {
        this.appenders = appenders;
    }

    @Override
    @JsonIgnore
    public boolean isEnabled() {
        return !this.appenders.isEmpty();
    }

    @Override
    public RequestLog build(String name) {
        Logger logger2 = (Logger)LoggerFactory.getLogger("http.request");
        logger2.setAdditive(false);
        LoggerContext context = logger2.getLoggerContext();
        LogbackAccessRequestLog requestLog = new LogbackAccessRequestLog();
        NullLevelFilterFactory levelFilterFactory = new NullLevelFilterFactory();
        AsyncAccessEventAppenderFactory asyncAppenderFactory = new AsyncAccessEventAppenderFactory();
        LogbackAccessRequestLayoutFactory layoutFactory = new LogbackAccessRequestLayoutFactory();
        for (AppenderFactory<IAccessEvent> output : this.appenders) {
            requestLog.addAppender(output.build(context, name, layoutFactory, levelFilterFactory, asyncAppenderFactory));
        }
        return requestLog;
    }
}

