/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.web.conf;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.util.Duration;
import io.dropwizard.web.conf.HeaderFactory;
import java.util.Collections;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class HstsHeaderFactory
extends HeaderFactory {
    private static final String STRICT_TRANSPORT_SECURITY = "Strict-Transport-Security";
    @Valid
    @NotNull
    @JsonProperty
    private Duration maxAge = Duration.days(365L);
    @JsonProperty
    private boolean includeSubDomains = true;
    @JsonProperty
    private boolean preload = false;

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Duration maxAge) {
        this.maxAge = maxAge;
    }

    public boolean isIncludeSubDomains() {
        return this.includeSubDomains;
    }

    public void setIncludeSubDomains(boolean includeSubDomains) {
        this.includeSubDomains = includeSubDomains;
    }

    public boolean isPreload() {
        return this.preload;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }

    @Override
    public Map<String, String> buildHeaders() {
        StringBuilder valueBuilder = new StringBuilder("max-age=");
        valueBuilder.append(this.maxAge.toSeconds());
        if (this.includeSubDomains) {
            valueBuilder.append("; includeSubDomains");
        }
        if (this.preload) {
            valueBuilder.append("; preload");
        }
        return Collections.singletonMap(STRICT_TRANSPORT_SECURITY, valueBuilder.toString());
    }
}

