/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal.hibernate;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.spi.BeanManager;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import org.glassfish.jersey.ext.cdi1x.internal.CdiUtil;
import org.glassfish.jersey.server.validation.internal.hibernate.DestructibleBeanInstance;

public class HibernateInjectingConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private final Map<Object, DestructibleBeanInstance<?>> constraintValidatorMap = Collections.synchronizedMap(new IdentityHashMap());
    private BeanManager beanManager;

    @PostConstruct
    void postConstruct() {
        this.beanManager = CdiUtil.getBeanManager();
    }

    @Override
    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        DestructibleBeanInstance<Class<T>> destructibleBeanInstance = new DestructibleBeanInstance<Class<T>>(this.beanManager, key);
        this.constraintValidatorMap.put(destructibleBeanInstance.getInstance(), destructibleBeanInstance);
        return (T)((ConstraintValidator)((Object)destructibleBeanInstance.getInstance()));
    }

    @Override
    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        DestructibleBeanInstance<?> destructibleBeanInstance = this.constraintValidatorMap.remove(instance);
        if (destructibleBeanInstance != null) {
            destructibleBeanInstance.destroy();
        }
    }
}

