// Generated by delombok at Thu May 22 14:06:18 UTC 2025
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;

@Schema(description = "The bundled billing information for display; separate from the claim pricing result.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-DATA-TEST", value = "<structure>")})})
public class BundledBillingData {
  @BigDecimalScale(scale = 4)
  @Schema(description = "The bundled body-mass index (BMI) factor.", example = "750.2412", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BUN-BMI", value = "PIC 9(03)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal bundledBodyMassIndexFactor;
  @BigDecimalScale(scale = 4)
  @Schema(description = "The bundled body-surface area (BSA) factor.", example = "12.4534", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BUN-BSA", value = "PIC 9(03)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal bundledBodySurfaceAreaFactor;
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The bundled comorbidity multiplier.", example = "7.439", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BUN-COMORBID-MULTIPLIER", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal bundledComorbidityMultiplier;
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The bundled low-volume facility adjustment percent.", example = "6.882", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BUN-LOW-VOL-MULTIPLIER", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal bundledLowVolumeFacilityAdjustmentPercent;
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "The bundled onset factor.", example = "3.4534", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BUN-ONSET-FACTOR", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal bundledOnsetFactor;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledBodyMassIndexFactor() {
    return this.bundledBodyMassIndexFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledBodySurfaceAreaFactor() {
    return this.bundledBodySurfaceAreaFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledComorbidityMultiplier() {
    return this.bundledComorbidityMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledLowVolumeFacilityAdjustmentPercent() {
    return this.bundledLowVolumeFacilityAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledOnsetFactor() {
    return this.bundledOnsetFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledBodyMassIndexFactor(final BigDecimal bundledBodyMassIndexFactor) {
    this.bundledBodyMassIndexFactor = bundledBodyMassIndexFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledBodySurfaceAreaFactor(final BigDecimal bundledBodySurfaceAreaFactor) {
    this.bundledBodySurfaceAreaFactor = bundledBodySurfaceAreaFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledComorbidityMultiplier(final BigDecimal bundledComorbidityMultiplier) {
    this.bundledComorbidityMultiplier = bundledComorbidityMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledLowVolumeFacilityAdjustmentPercent(final BigDecimal bundledLowVolumeFacilityAdjustmentPercent) {
    this.bundledLowVolumeFacilityAdjustmentPercent = bundledLowVolumeFacilityAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledOnsetFactor(final BigDecimal bundledOnsetFactor) {
    this.bundledOnsetFactor = bundledOnsetFactor;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof BundledBillingData)) return false;
    final BundledBillingData other = (BundledBillingData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$bundledBodyMassIndexFactor = this.getBundledBodyMassIndexFactor();
    final java.lang.Object other$bundledBodyMassIndexFactor = other.getBundledBodyMassIndexFactor();
    if (this$bundledBodyMassIndexFactor == null ? other$bundledBodyMassIndexFactor != null : !this$bundledBodyMassIndexFactor.equals(other$bundledBodyMassIndexFactor)) return false;
    final java.lang.Object this$bundledBodySurfaceAreaFactor = this.getBundledBodySurfaceAreaFactor();
    final java.lang.Object other$bundledBodySurfaceAreaFactor = other.getBundledBodySurfaceAreaFactor();
    if (this$bundledBodySurfaceAreaFactor == null ? other$bundledBodySurfaceAreaFactor != null : !this$bundledBodySurfaceAreaFactor.equals(other$bundledBodySurfaceAreaFactor)) return false;
    final java.lang.Object this$bundledComorbidityMultiplier = this.getBundledComorbidityMultiplier();
    final java.lang.Object other$bundledComorbidityMultiplier = other.getBundledComorbidityMultiplier();
    if (this$bundledComorbidityMultiplier == null ? other$bundledComorbidityMultiplier != null : !this$bundledComorbidityMultiplier.equals(other$bundledComorbidityMultiplier)) return false;
    final java.lang.Object this$bundledLowVolumeFacilityAdjustmentPercent = this.getBundledLowVolumeFacilityAdjustmentPercent();
    final java.lang.Object other$bundledLowVolumeFacilityAdjustmentPercent = other.getBundledLowVolumeFacilityAdjustmentPercent();
    if (this$bundledLowVolumeFacilityAdjustmentPercent == null ? other$bundledLowVolumeFacilityAdjustmentPercent != null : !this$bundledLowVolumeFacilityAdjustmentPercent.equals(other$bundledLowVolumeFacilityAdjustmentPercent)) return false;
    final java.lang.Object this$bundledOnsetFactor = this.getBundledOnsetFactor();
    final java.lang.Object other$bundledOnsetFactor = other.getBundledOnsetFactor();
    if (this$bundledOnsetFactor == null ? other$bundledOnsetFactor != null : !this$bundledOnsetFactor.equals(other$bundledOnsetFactor)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof BundledBillingData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $bundledBodyMassIndexFactor = this.getBundledBodyMassIndexFactor();
    result = result * PRIME + ($bundledBodyMassIndexFactor == null ? 43 : $bundledBodyMassIndexFactor.hashCode());
    final java.lang.Object $bundledBodySurfaceAreaFactor = this.getBundledBodySurfaceAreaFactor();
    result = result * PRIME + ($bundledBodySurfaceAreaFactor == null ? 43 : $bundledBodySurfaceAreaFactor.hashCode());
    final java.lang.Object $bundledComorbidityMultiplier = this.getBundledComorbidityMultiplier();
    result = result * PRIME + ($bundledComorbidityMultiplier == null ? 43 : $bundledComorbidityMultiplier.hashCode());
    final java.lang.Object $bundledLowVolumeFacilityAdjustmentPercent = this.getBundledLowVolumeFacilityAdjustmentPercent();
    result = result * PRIME + ($bundledLowVolumeFacilityAdjustmentPercent == null ? 43 : $bundledLowVolumeFacilityAdjustmentPercent.hashCode());
    final java.lang.Object $bundledOnsetFactor = this.getBundledOnsetFactor();
    result = result * PRIME + ($bundledOnsetFactor == null ? 43 : $bundledOnsetFactor.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "BundledBillingData(bundledBodyMassIndexFactor=" + this.getBundledBodyMassIndexFactor() + ", bundledBodySurfaceAreaFactor=" + this.getBundledBodySurfaceAreaFactor() + ", bundledComorbidityMultiplier=" + this.getBundledComorbidityMultiplier() + ", bundledLowVolumeFacilityAdjustmentPercent=" + this.getBundledLowVolumeFacilityAdjustmentPercent() + ", bundledOnsetFactor=" + this.getBundledOnsetFactor() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BundledBillingData() {
  }
}
