// Generated by delombok at Thu May 22 14:06:59 UTC 2025
package gov.cms.fiss.pricers.esrd.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.AdditionalPricingData;
import gov.cms.fiss.pricers.esrd.api.v2.BundledBillingData;
import gov.cms.fiss.pricers.esrd.api.v2.BundledPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.ComorbidityData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.OutlierBillingData;
import gov.cms.fiss.pricers.esrd.api.v2.PaymentBillingData;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;
import gov.cms.fiss.pricers.esrd.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class EsrdPricerContext extends CalculationContext<EsrdClaimPricingRequest, EsrdClaimPricingResponse> {
  public static final String CONDITION_CODE_SELF_CARE_TRAINING_73 = "73";
  public static final String CONDITION_CODE_HOME_SERVICES_74 = "74";
  public static final String CONDITION_CODE_IN_FACILITY_BACK_UP_76 = "76";
  public static final String CONDITION_CODE_AKI_MONTHLY_84 = "84";
  public static final String CONDITION_CODE_SELF_CARE_RETRAINING_87 = "87";
  public static final String COMORBIDITY_RETURN_CODE_DEFAULT_10 = "10";
  public static final String COMORBIDITY_RETURN_CODE_GASTROENTERITIS_20 = "20";
  public static final String COMORBIDITY_RETURN_CODE_PNEUMONIA_30 = "30";
  public static final String COMORBIDITY_RETURN_CODE_PERICARDITIS_40 = "40";
  public static final String COMORBIDITY_RETURN_CODE_MYELODYDISPLASTIC_SYNDROME_50 = "50";
  public static final String COMORBIDITY_RETURN_CODE_HEMOLYTIC_SICKLE_CELL_60 = "60";
  public static final String COMORBIDITY_RETURN_CODE_MONOCLONAL_GAMMOPATHY_70 = "70";
  /**
   * Indicates claim is from an ESRD facility or Managing Clinician that participates in the ESRD
   * Treatment Choices (ETC) Model.
   */
  public static final String DEMO_CODE_ETC_PARTICIPANT = "94";
  public static final BigDecimal QIP_REDUCTION_NONE = new BigDecimal("1.000");
  public static final BigDecimal QIP_REDUCTION_HALF_PCT = new BigDecimal("0.995");
  public static final BigDecimal QIP_REDUCTION_ONE_PCT = new BigDecimal("0.990");
  public static final BigDecimal QIP_REDUCTION_ONE_AND_HALF_PCT = new BigDecimal("0.985");
  public static final BigDecimal QIP_REDUCTION_TWO_PCT = new BigDecimal("0.980");
  public static final BigDecimal BMI_CUTOFF_18_POINT_5 = new BigDecimal("18.5");
  public static final String REVENUE_CODE_HEMODIALYSIS_0821 = "0821";
  public static final String REVENUE_CODE_PERITONEAL_DIALYSIS_0831 = "0831";
  public static final String REVENUE_CODE_CONTINUOUS_AMBULATORY_PERITONEAL_DIALYSIS_0841 = "0841";
  public static final String REVENUE_CODE_CONTINUOUS_CYCLING_PERITONEAL_DIALYSIS_0851 = "0851";
  public static final String REVENUE_CODE_MISCELLANEOUS_DIALYSIS_0881 = "0881";
  /**
   * Default factor value; a unit amount with scale 4.
   */
  public static final BigDecimal DEFAULT_FACTOR = new BigDecimal("1.0000");
  /**
   * Default multiplier value; a unit amount with scale 3.
   */
  public static final BigDecimal DEFAULT_MULTIPLIER = new BigDecimal("1.000");
  /**
   * Corresponds to {@code CASE-MIX-BDGT-NEUT-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  public static final BigDecimal CASE_MIX_BUDGET_NEUTRAL_FACTOR = new BigDecimal("0.9116");
  /**
   * Corresponds to {@code CR-BSA PIC 9(01)V9(03)} from the COBOL source.
   */
  public static final BigDecimal COMPOSITE_RATE_BSA_MULTIPLIER = new BigDecimal("1.037");
  /**
   * Corresponds to {@code CR-BMI-LT-18-5 PIC 9(01)V9(03)} from the COBOL source.
   *
   * @see #BMI_CUTOFF_18_POINT_5
   */
  public static final BigDecimal COMPOSITE_RATE_BMI_UNDER_CUTOFF_MULTIPLIER = new BigDecimal("1.112");
  /**
   * Corresponds to {@code TRANSITION-BDGT-NEUT-FACTOR PIC 9(01)V9(04) PIC 9(01)V9(04)} from the
   * COBOL source.
   */
  public static final BigDecimal TRANSITION_BUDGET_NEUTRAL_FACTOR = new BigDecimal("1.0000");
  // Upper bound for calculated body mass index.
  public static final BigDecimal MAX_BMI_AMOUNT = new BigDecimal("999.9999");
  public static final String ETC_INDICATOR_HDPA = "H";
  public static final String ETC_INDICATOR_HDPA_NOTHING = " ";
  public static final String ETC_INDICATOR_PPA = "P";
  public static final String ETC_INDICATOR_BOTH_HDPA_AND_PPA = "B";
  private static final String[] VALID_CONDITION_CODES = new String[] {CONDITION_CODE_SELF_CARE_TRAINING_73, CONDITION_CODE_HOME_SERVICES_74, CONDITION_CODE_IN_FACILITY_BACK_UP_76, CONDITION_CODE_AKI_MONTHLY_84, CONDITION_CODE_SELF_CARE_RETRAINING_87};
  private static final String[] VALID_COMORBIDITY_RETURN_CODES = new String[] {COMORBIDITY_RETURN_CODE_DEFAULT_10, COMORBIDITY_RETURN_CODE_GASTROENTERITIS_20, COMORBIDITY_RETURN_CODE_PERICARDITIS_40, COMORBIDITY_RETURN_CODE_MYELODYDISPLASTIC_SYNDROME_50, COMORBIDITY_RETURN_CODE_HEMOLYTIC_SICKLE_CELL_60};
  private static final String[] VALID_PROVIDER_TYPES = new String[] {"05", "40", "41"};
  private static final String[] VALID_QIP_REDUCTION_CODES = new String[] {"1", "2", "3", "4"};
  private static final String[] VALID_SPECIAL_LOCALITY_INDICATOR_CODES = new String[] {"1", "2"};
  private static final String[] VALID_REVENUE_CODES = new String[] {REVENUE_CODE_HEMODIALYSIS_0821, REVENUE_CODE_PERITONEAL_DIALYSIS_0831, REVENUE_CODE_CONTINUOUS_AMBULATORY_PERITONEAL_DIALYSIS_0841, REVENUE_CODE_CONTINUOUS_CYCLING_PERITONEAL_DIALYSIS_0851, REVENUE_CODE_MISCELLANEOUS_DIALYSIS_0881};
  @JsonIgnore
  private final DataTables dataTables;
  /**
   * Corresponds to {@code P-PROV-WAIVE-BLEND-PAY-INDIC PIC X(01)} from the COBOL source.
   */
  private boolean blendedPaymentWaived;
  /**
   * Corresponds to {@code COMORBID-DATA} from the COBOL source.
   */
  private List<String> comorbidityCodes = new ArrayList<>();
  /**
   * Corresponds to {@code H-COMORBID-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal comorbidityMultiplier = DEFAULT_MULTIPLIER;
  /**
   * Corresponds to {@code H-CC-74-PER-DIEM-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal conditionCode74PerDiemAmount = BigDecimal.ZERO;
  private BigDecimal craTpniesPayment = BigDecimal.ZERO;
  private BigDecimal tpeapaPayment = BigDecimal.ZERO;
  private BigDecimal postTdapaPayment = BigDecimal.ZERO;
  private BigDecimal caseMixAdjuster = BigDecimal.ZERO;
  private BigDecimal patientLevelCaseMixAdjusterForPostTdapa = BigDecimal.ZERO;
  /**
   * Corresponds to {@code COMORBID-CWF-RETURN-CODE PIC X(02)} from the COBOL source.
   */
  private String cwfReturnCode;
  /**
   * Corresponds to {@code H-FINAL-AMT-WITHOUT-HDPA PIC 9(07)V9(02)} from the COBOL source.
   */
  private BigDecimal finalAmountWithoutHdpa = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-FINAL-AMT-WITH-HDPA PIC 9(07)V9(02)} from the COBOL source.
   */
  private BigDecimal finalAmountWithHdpa = BigDecimal.ZERO;
  /**
   * CR12492 July 1, 2022 implementation.
   */
  private BigDecimal finalAmountWithoutPpa = BigDecimal.ZERO;
  /**
   * CR12492 July 1, 2022 implementation.
   */
  private BigDecimal finalAmountWithPpa = BigDecimal.ZERO;
  /**
   * CR12492 July 1, 2022 implementation.
   */
  private BigDecimal finalAmountWithoutEtc = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-PPS-FINAL-PAY-AMT PIC 9(07)V9(02)} from the COBOL source.
   */
  private BigDecimal finalPaymentAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-FULL-CLAIM-AMT PIC 9(07)V9(02)} from the COBOL source.
   */
  private BigDecimal fullClaimAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-HEMO-EQUIV-DIAL-SESSIONS PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal hemoEquivalentDialysisSessions = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-NETWORK-REDUCTION PIC 9(01)V9(02)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal networkReductionAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-PATIENT-AGE PIC 9(03)} from the COBOL source.
   */
  private int patientAge;
  /**
   * Corresponds to {@code H-PER-DIEM-AMT-WITHOUT-HDPA PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal perDiemAmountWithoutHdpa = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-PER-DIEM-AMT-WITH-HDPA PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal perDiemAmountWithHdpa = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-PER-DIEM-AMT-WITHOUT-HDPA PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal perDiemAmountWithoutEtc = BigDecimal.ZERO;
  /**
   * CR12492 July 1, 2022 implementation.
   */
  private BigDecimal perDiemAmountWithoutPpa = BigDecimal.ZERO;
  /**
   * CR12492 July 1, 2022 implementation.
   */
  private BigDecimal perDiemAmountWithPpa = BigDecimal.ZERO;
  /**
   * Corresponds to {@code QIP-REDUCTION PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal qipReduction = QIP_REDUCTION_NONE;
  /**
   * Corresponds to {@code H-TDAPA-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal tdapaPayment = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-TPNIES-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal tpniesPayment = BigDecimal.ZERO;
  // Bundled data
  /**
   * Corresponds to {@code H-BUN-ADJUSTED-BASE-WAGE-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal bundledAdjustedBaseWageAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-AGE-FACTOR PIC PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal bundledAgeAdjustmentFactor = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-BMI PIC 9(03)V9(04)} from the COBOL source.
   */
  private BigDecimal bundledBmi = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-BMI-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal bundledBmiFactor = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-BSA PIC 9(03)V9(04)} from the COBOL source.
   */
  private BigDecimal bundledBsa = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-BSA-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  private BigDecimal bundledBsaFactor = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-COMORBID-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal bundledComorbidityMultiplier = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-LOW-VOL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal bundledLowVolumeMultiplier = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal bundledLowVolumeTierOneMultiplier = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal bundledLowVolumeTierTwoMultiplier = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-NAT-LABOR-AMT PIC 9(04)V9(02)} from the COBOL source.
   */
  private BigDecimal bundledNationalLaborAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-NAT-NONLABOR-AMT PIC 9(04)V9(02)} from the COBOL source.
   */
  private BigDecimal bundledNationalNonLaborAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-BASE-WAGE-AMT PIC 9(04)V9(04)} from the COBOL source.
   */
  private BigDecimal bundledBaseWageAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-ONSET-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal bundledOnsetFactor = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-RURAL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  private BigDecimal bundledRuralMultiplier = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-BUN-WAGE-ADJ-TRAINING-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal bundledWageAdjustedTrainingAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code BUN-CBSA-W-INDEX PIC 9(02)V9(04)} from the COBOL source.
   */
  private BigDecimal bundledWageIndex = BigDecimal.ZERO;
  /**
   * Updated ppaAdjustmentPercent field to allow ZERO in CY2025. The following code limits the range
   * of this field to 0.9000 to 0.1800, otherwise the claim returns an error code.
   */
  private static final BigDecimal MIN_PPA_ADJUSTMENT_PERCENT = new BigDecimal("0.9000");
  private static final BigDecimal MAX_PPA_ADJUSTMENT_PERCENT = new BigDecimal("1.0800");

  public boolean isValidPpaAdjustmentPercent() {
    final BigDecimal percent = getClaimData().getPpaAdjustmentPercent();
    return BigDecimalUtils.isGreaterThanOrEqualTo(percent, MIN_PPA_ADJUSTMENT_PERCENT) && BigDecimalUtils.isLessThanOrEqualTo(percent, MAX_PPA_ADJUSTMENT_PERCENT);
  }

  // Low-volume data
  /**
   * Corresponds to {@code H-LV-BUN-ADJUST-BASE-WAGE-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal lowVolumeBundledAdjustedBaseWageAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-LV-OUT-CM-ADJ-PREDICT-M-TRT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-LV-PPS-FINAL-PAY-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal lowVolumeFinalPaymentAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-LV-OUT-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal lowVolumeOutlierPayment = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-LV-OUT-PREDICTED-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal lowVolumeOutlierPredictedMap = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-LV-OUT-PREDICT-SERVICES-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal lowVolumeOutlierPredictedSvcsMap = BigDecimal.ZERO;
  // Outlier data
  /**
   * Corresponds to {@code H-OUT-ADJ-AVG-MAP-AMT PIC 9(03)V9(02)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal outlierAdjustedAverageMapAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-AGE-FACTOR PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal outlierAgeAdjustmentFactor = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-BMI PIC 9(03)V9(04)} from the COBOL source.
   */
  private BigDecimal outlierBmi = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-BMI-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal outlierBmiFactor = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-BSA PIC 9(03)V9(04)} from the COBOL source.
   */
  private BigDecimal outlierBsa = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-BSA-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  private BigDecimal outlierBsaFactor = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-CM-ADJ-PREDICT-MAP-TRT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal outlierCaseMixAdjPredictedMapTrt = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-COMORBID-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal outlierComorbidityMultiplier = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-HEMO-EQUIV-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal outlierHemoEquivalentPayment = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-IMPUTED-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal outlierImputedMapAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-FIX-DOLLAR-LOSS PIC 9(04)V9(02)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal outlierFixedDollarLoss = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-LOSS-SHARING-PCT PIC 9(01)V9(02)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal outlierLossSharingPercentage = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-LOW-VOL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal outlierLowVolumeMultiplier = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal outlierLowVolumeTierOneMultiplier = BigDecimal.ZERO;
  @FixedValue
  private BigDecimal outlierLowVolumeTierTwoMultiplier = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-ONSET-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal outlierOnsetFactor = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-RURAL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  private BigDecimal outlierRuralMultiplier = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal outlierPayment = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-PREDICTED-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal outlierPredictedMapAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code H-OUT-PREDICTED-SERVICES-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  private BigDecimal outlierPredictedSvcsMapAmount = BigDecimal.ZERO;
  // Tracking flags
  /**
   * Corresponds to {@code ACUTE-COMORBID-TRACK PIC X(01)} from the COBOL source.
   */
  private boolean acuteComorbidityFound;
  /**
   * Corresponds to {@code CHRONIC-COMORBID-TRACK PIC X(01)} from the COBOL source.
   */
  private boolean chronicComorbidityFound;
  /**
   * Corresponds to {@code LOW-BMI-TRACK PIC X(01)} from the COBOL source.
   */
  private boolean lowBmiClaim;
  /**
   * Corresponds to {@code LOW-VOLUME-TRACK PIC X(01)} from the COBOL source.
   */
  private boolean lowVolumeClaim;
  /**
   * Corresponds to {@code OUTLIER-TRACK PIC X(01)} from the COBOL source.
   */
  private boolean outlierClaim;
  /**
   * Corresponds to {@code PEDIATRIC-TRACK PIC X(01)} from the COBOL source.
   */
  private boolean pediatricClaim;
  /**
   * Corresponds to {@code ONSET-TRACK PIC X(01)} from the COBOL source.
   */
  private boolean onsetRecent;
  /**
   * Corresponds to {@code TRAINING-TRACK PIC X(01)} from the COBOL source.
   */
  private boolean trainingClaim;
  private boolean aki84;
  private boolean esrdFacility;
  private boolean akiTraining8473;
  private boolean akiHome8474;
  private boolean akiRetraining8487;
  private boolean esrdTraining73;
  private boolean esrdHome74;
  private boolean esrdBackup76;
  private boolean akiFacility84;
  private boolean esrdRetraining87;

  protected EsrdPricerContext(EsrdClaimPricingRequest input, EsrdClaimPricingResponse output, DataTables dataTables) {
    super(input, output);
    this.dataTables = dataTables;
    initializeOutput();
    postTdapaPayment = BigDecimal.ZERO;
  }

  protected void initializeOutput() {
  }

  /**
   * Corresponds to {@code PPS-CALC-VERS-CD} from the COBOL source.
   */
  public abstract String getCalculationVersion();

  // Access to API content
  @JsonIgnore
  public EsrdClaimData getClaimData() {
    return getInput().getClaimData();
  }

  @JsonIgnore
  public BundledPaymentData getBundledData() {
    if (getPaymentData().getBundledPaymentInformation() == null) {
      getPaymentData().setBundledPaymentInformation(new BundledPaymentData());
    }
    return getPaymentData().getBundledPaymentInformation();
  }

  @JsonIgnore
  public ComorbidityData getComorbidities() {
    return Optional.ofNullable(getClaimData().getComorbidities()).orElse(new ComorbidityData());
  }

  @JsonIgnore
  public EsrdPaymentData getPaymentData() {
    return getOutput().getPaymentData();
  }

  @JsonIgnore
  public BundledBillingData getBundledBillingData() {
    return getOutput().getBundledBillingInformation();
  }

  @JsonIgnore
  public PaymentBillingData getPaymentBillingData() {
    return getOutput().getPaymentBillingInformation();
  }

  @JsonIgnore
  public OutlierBillingData getOutlierBillingData() {
    return getOutput().getOutlierBillingInformation();
  }

  @JsonIgnore
  public AdditionalPricingData getAdditionalPricingData() {
    return getOutput().getAdditionalPricingInformation();
  }

  @JsonIgnore
  public OutpatientProviderData getProviderData() {
    return getInput().getProviderData();
  }

  // Calculation data
  public void applyReturnCode(ReturnCode returnCode) {
    getOutput().setReturnCodeData(returnCode.toReturnCodeData());
  }

  public boolean matchesReturnCode(ReturnCode expectedCode) {
    return expectedCode.equals(ReturnCode.fromCode(Integer.parseInt(getOutput().getReturnCodeData().getCode())));
  }

  public boolean isLowVolume() {
    return StringUtils.equalsAny(getProviderData().getSpecialLocalityIndicator(), "Y", "1", "2");
  }

  public boolean isLowVolumeClaimTierOne() {
    return StringUtils.equals(getProviderData().getSpecialLocalityIndicator(), "1");
  }

  public boolean isLowVolumeClaimTierTwo() {
    return StringUtils.equals(getProviderData().getSpecialLocalityIndicator(), "2");
  }

  public boolean hasDemoCode(String code) {
    return getClaimData().getDemoCodes() != null && getClaimData().getDemoCodes().stream().anyMatch(c -> StringUtils.equals(c, code));
  }

  public boolean hasConditionCode(String code) {
    return getClaimData().getConditionCodes() != null && getClaimData().getConditionCodes().stream().anyMatch(c -> StringUtils.equals(c, code));
  }

  // Per-year value retrieval
  /**
   * Corresponds to {@code ADJ-AVG-MAP-AMT-GT-17 PIC 9(04)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getAdjustedAverageMapAmountOver17();

  /**
   * Corresponds to {@code ADJ-AVG-MAP-AMT-LT-18 PIC 9(04)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getAdjustedAverageMapAmountUnder18();

  /**
   * Corresponds to {@code BSBASE-PAYMENT-RATE PIC 9(04)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getBasePaymentRate();

  /**
   * Corresponds to {@code BSA-NATIONAL-AVERAGE PIC 9(01)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getBsaNationalAverage();

  /**
   * Corresponds to {@code BUNDLED-BASE-PMT-RATE PIC 9(04)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getBundledBasePaymentRate();

  // added 2025
  @FixedValue
  public abstract BigDecimal getBundledBasePaymentRateAki();

  /**
   * Corresponds to {@code BUN-NAT-LABOR-PCT PIC 9(04)V9(02)} from the COBOL source. Must add up to
   * {@code 1} with {@code getBundledNationalNonLaborPercentage}.
   */
  @FixedValue
  public abstract BigDecimal getBundledNationalLaborPercentage();

  /**
   * Corresponds to {@code BUN-NAT-NONLABOR-PCT PIC 9(04)V9(02)} from the COBOL source. Must add up
   * to {@code 1} with {@code getBundledNationalLaborPercentage}.
   */
  @FixedValue
  public abstract BigDecimal getBundledNationalNonLaborPercent();

  /**
   * Corresponds to {@code CM-AGE-18-44 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixAge18To44Multiplier();

  /**
   * Corresponds to {@code CM-AGE-45-59 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixAge45To59Multiplier();

  /**
   * Corresponds to {@code CM-AGE-60-69 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixAge60To69Multiplier();

  /**
   * Corresponds to {@code CM-AGE-70-79 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixAge70To79Multiplier();

  /**
   * Corresponds to {@code CM-AGE-80-PLUS PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixAge80PlusMultiplier();

  /**
   * Corresponds to {@code CM-BMI-LT-18-5 PIC 9(01)V9(03)} from the COBOL source.
   *
   * @see #BMI_CUTOFF_18_POINT_5
   */
  @FixedValue
  public abstract BigDecimal getCaseMixBmiUnderEighteenPointFiveMultiplier();

  /**
   * Corresponds to {@code CM-BSA PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixBsaMultiplier();

  /**
   * Corresponds to {@code CM-GI-BLEED PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixGastrointestinalBleedMultiplier();

  /**
   * Corresponds to {@code CM-LOW-VOL-ADJ-LT-4000 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixLowVolumeAdjustmentLessThan4000Multiplier();

  @FixedValue
  public abstract BigDecimal getCaseMixLowVolumeAdjustmentLessThan3000Multiplier();

  @FixedValue
  public abstract BigDecimal getCaseMixLowVolumeAdjustment3001To3999Multiplier();

  /**
   * Corresponds to {@code CM-MYELODYSPLASTIC PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixMyelodysplasticSyndromeMultiplier();

  /**
   * Corresponds to {@code CM-ONSET-LE-120 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixOnsetLessThanOrEqualTo120Multiplier();

  /**
   * Corresponds to {@code CM-PERICARDITIS PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixPericarditisMultiplier();

  /**
   * Corresponds to {@code CM-RURAL PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixRuralMultiplier();

  /**
   * Corresponds to {@code CM-SICKEL-CELL PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getCaseMixSickleCellMultiplier();

  /**
   * Corresponds to {@code DRUG-ADDON PIC 9(01)V9(04)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getDrugAddOn();

  /**
   * Corresponds to {@code ETC-HDPA-PCT PIC 9V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getEtcHdpaPercent();

  /**
   * too new to be in the COBOL source.
   */
  public abstract BigDecimal getCraTpniesOffset();

  /**
   * Corresponds to {@code EB-AGE-13-17-HEMO-MODE PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getExpandedBundle13To17HemodialysisModePaymentMultiplier();

  /**
   * Corresponds to {@code EB-AGE-13-17-PD-MODE PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getExpandedBundle13To17PeritonealDialysisModePaymentMultiplier();

  /**
   * Corresponds to {@code EB-AGE-LT-13-HEMO-MODE PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getExpandedBundleUnder13HemodialysisModePaymentMultiplier();

  /**
   * Corresponds to {@code EB-AGE-LT-13-PD-MODE PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getExpandedBundleUnder13PeritonealDialysisModePaymentMultiplier();

  /**
   * Corresponds to {@code FIX-DOLLAR-LOSS-GT-17 PIC 9(04)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getFixedDollarLossOver17();

  /**
   * Corresponds to {@code FIX-DOLLAR-LOSS-LT-18 PIC 9(04)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getFixedDollarLossUnder18();

  /**
   * Corresponds to {@code LOSS-SHARING-PCT-GT-17 PIC 9(03)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getLossSharingPercentageOver17();

  /**
   * Corresponds to {@code LOSS-SHARING-PCT-LT-18 PIC 9(03)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getLossSharingPercentageUnder18();

  /**
   * Corresponds to {@code NAT-LABOR-PCT PIC 9(01)V9(05)} from the COBOL source. Must add up to
   * {@code 1} with {@code getNationalNonLaborPercentage}.
   */
  @FixedValue
  public abstract BigDecimal getNationalLaborPercent();

  @FixedValue
  public abstract BigDecimal getNetworkReductionPerDiemAmount();

  @FixedValue
  public abstract BigDecimal getNetworkReductionFullAmount();

  /**
   * Corresponds to {@code NAT-NONLABOR-PCT PIC 9(01)V9(05)} from the COBOL source. Must add up to
   * {@code 1} with {@code getNationalLaborPercentage}.
   */
  @FixedValue
  public abstract BigDecimal getNationalNonLaborPercent();

  /**
   * /** Corresponds to {@code SB-AGE-13-17-HEMO-MODE PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillable13To17HemodialysisModePaymentMultiplier();

  /**
   * Corresponds to {@code SB-AGE-13-17-PD-MODE PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillable13To17PeritonealDialysisModePaymentMultiplier();

  /**
   * Corresponds to {@code SB-AGE-18-44 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableAge18To44Multiplier();

  /**
   * Corresponds to {@code SB-AGE-45-59 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableAge45To59Multiplier();

  /**
   * Corresponds to {@code SB-AGE-60-69 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableAge60To69Multiplier();

  /**
   * Corresponds to {@code SB-AGE-70-79 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableAge70To79Multiplier();

  /**
   * Corresponds to {@code SB-AGE-80-PLUS PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableAge80PlusMultiplier();

  /**
   * Corresponds to {@code SB-BMI-LT-18-5 PIC 9(01)V9(03)} from the COBOL source.
   *
   * @see #BMI_CUTOFF_18_POINT_5
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableBmiUnderCutoffMultiplier();

  /**
   * Corresponds to {@code SB-BSA PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableBsa();

  /**
   * Corresponds to {@code SB-GI-BLEED PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableGastrointestinalBleedMultiplier();

  /**
   * Corresponds to {@code SB-LOW-VOL-ADJ-LT-4000 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableLowVolumeAdjustmentLessThan4000Multiplier();

  @FixedValue
  public abstract BigDecimal getSeparatelyBillableLowVolumeAdjustmentLessThan3000Multiplier();

  @FixedValue
  public abstract BigDecimal getSeparatelyBillableLowVolumeAdjustment3000To3999Multiplier();

  /**
   * Corresponds to {@code CM-MYELODYSPLASTIC PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableMyelodysplasticSyndromeMultiplier();

  /**
   * Corresponds to {@code SB-ONSET-LE-120 PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableOnsetLessThanOrEqualTo120Multiplier();

  /**
   * Corresponds to {@code SB-PERICARDITIS PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillablePericarditisMultiplier();

  /**
   * Corresponds to {@code SB-RURAL PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableRuralMultiplier();

  /**
   * Corresponds to {@code SB-SICKEL-CELL PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableSickleCellMultiplier();

  /**
   * Corresponds to {@code SB-AGE-LT-13-HEMO-MODE PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableUnder13HemodialysisModePaymentMultiplier();

  /**
   * Corresponds to {@code SB-AGE-LT-13-PD-MODE PIC 9(01)V9(03)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getSeparatelyBillableUnder13PeritonealDialysisModePaymentMultiplier();

  /**
   * Corresponds to {@code TRAINING-ADD-ON-PMT-AMT PIC 9(02)V9(02)} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getTrainingAddOnPaymentAmount();

  // Input business methods
  public boolean isComorbidityReturnCodeInvalid() {
    return !ArrayUtils.contains(VALID_COMORBIDITY_RETURN_CODES, getComorbidities().getCwfReturnCode());
  }

  public boolean areConditionCodesInvalid() {
    return !ArrayUtils.contains(VALID_CONDITION_CODES, getClaimData().getConditionCodes());
  }

  public boolean isQipReductionInvalid() {
    final String providerQipReduction = getProviderData().getHospitalQualityIndicator();
    return StringUtils.isNotBlank(providerQipReduction) && !ArrayUtils.contains(VALID_QIP_REDUCTION_CODES, providerQipReduction);
  }

  public boolean isSpecialLocalityIndicatorInvalid() {
    final String providerSpecialLocalityIndicator = getProviderData().getSpecialLocalityIndicator();
    return StringUtils.isNotBlank(providerSpecialLocalityIndicator) && !ArrayUtils.contains(VALID_SPECIAL_LOCALITY_INDICATOR_CODES, providerSpecialLocalityIndicator);
  }

  public boolean isProviderTypeInvalid() {
    return !ArrayUtils.contains(VALID_PROVIDER_TYPES, getProviderData().getProviderType());
  }

  public boolean isRevenueCodeInvalid() {
    return !ArrayUtils.contains(VALID_REVENUE_CODES, getClaimData().getRevenueCode());
  }

  public boolean isCbsaRural() {
    return 2 == getCbsa().length();
  }

  public boolean isCbsaUrban() {
    return 5 == getCbsa().length();
  }

  @JsonIgnore
  public String getCbsa() {
    return RegExUtils.replacePattern(getProviderData().getCbsaActualGeographicLocation(), "^[ 9]{3}", StringUtils.EMPTY);
  }

  // Helper methods
  public boolean isAdultPatient() {
    return getPatientAge() > 17;
  }

  /**
   * Determines the body-mass index based on the patient weight/height.
   *
   * @return the calculated value
   */
  public BigDecimal calculateBodyMassIndex() {
    final EsrdClaimData claimData = getClaimData();
    return claimData.getPatientWeight().divide(BigDecimalUtils.pow(claimData.getPatientHeight(), new BigDecimal("2"), 9), 5, RoundingMode.DOWN).multiply(new BigDecimal("10000"));
  }

  /**
   * Determines the body surface area based on the patient weight/height.
   *
   * @return the calculated value
   */
  public BigDecimal calculateBodySurfaceArea() {
    final EsrdClaimData claimData = getClaimData();
    return new BigDecimal(".007184").multiply(BigDecimalUtils.pow(claimData.getPatientHeight(), new BigDecimal(".725"), 9)).multiply(BigDecimalUtils.pow(claimData.getPatientWeight(), new BigDecimal(".425"), 9)).setScale(4, RoundingMode.HALF_UP);
  }

  /**
   * Checks the condition code and revenue code to determine if the claim is per diem.
   *
   * @return boolean
   */
  public boolean isPerDiemClaim() {
    return isEsrdHome74() && StringUtils.equalsAny(getClaimData().getRevenueCode(), EsrdPricerContext.REVENUE_CODE_CONTINUOUS_AMBULATORY_PERITONEAL_DIALYSIS_0841, EsrdPricerContext.REVENUE_CODE_CONTINUOUS_CYCLING_PERITONEAL_DIALYSIS_0851);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DataTables getDataTables() {
    return this.dataTables;
  }

  /**
   * Corresponds to {@code P-PROV-WAIVE-BLEND-PAY-INDIC PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isBlendedPaymentWaived() {
    return this.blendedPaymentWaived;
  }

  /**
   * Corresponds to {@code P-PROV-WAIVE-BLEND-PAY-INDIC PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBlendedPaymentWaived(final boolean blendedPaymentWaived) {
    this.blendedPaymentWaived = blendedPaymentWaived;
  }

  /**
   * Corresponds to {@code COMORBID-DATA} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getComorbidityCodes() {
    return this.comorbidityCodes;
  }

  /**
   * Corresponds to {@code COMORBID-DATA} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setComorbidityCodes(final List<String> comorbidityCodes) {
    this.comorbidityCodes = comorbidityCodes;
  }

  /**
   * Corresponds to {@code H-COMORBID-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getComorbidityMultiplier() {
    return this.comorbidityMultiplier;
  }

  /**
   * Corresponds to {@code H-COMORBID-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setComorbidityMultiplier(final BigDecimal comorbidityMultiplier) {
    this.comorbidityMultiplier = comorbidityMultiplier;
  }

  /**
   * Corresponds to {@code H-CC-74-PER-DIEM-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getConditionCode74PerDiemAmount() {
    return this.conditionCode74PerDiemAmount;
  }

  /**
   * Corresponds to {@code H-CC-74-PER-DIEM-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConditionCode74PerDiemAmount(final BigDecimal conditionCode74PerDiemAmount) {
    this.conditionCode74PerDiemAmount = conditionCode74PerDiemAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCraTpniesPayment() {
    return this.craTpniesPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCraTpniesPayment(final BigDecimal craTpniesPayment) {
    this.craTpniesPayment = craTpniesPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTpeapaPayment() {
    return this.tpeapaPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTpeapaPayment(final BigDecimal tpeapaPayment) {
    this.tpeapaPayment = tpeapaPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPostTdapaPayment() {
    return this.postTdapaPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPostTdapaPayment(final BigDecimal postTdapaPayment) {
    this.postTdapaPayment = postTdapaPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCaseMixAdjuster() {
    return this.caseMixAdjuster;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaseMixAdjuster(final BigDecimal caseMixAdjuster) {
    this.caseMixAdjuster = caseMixAdjuster;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPatientLevelCaseMixAdjusterForPostTdapa() {
    return this.patientLevelCaseMixAdjusterForPostTdapa;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientLevelCaseMixAdjusterForPostTdapa(final BigDecimal patientLevelCaseMixAdjusterForPostTdapa) {
    this.patientLevelCaseMixAdjusterForPostTdapa = patientLevelCaseMixAdjusterForPostTdapa;
  }

  /**
   * Corresponds to {@code COMORBID-CWF-RETURN-CODE PIC X(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCwfReturnCode() {
    return this.cwfReturnCode;
  }

  /**
   * Corresponds to {@code COMORBID-CWF-RETURN-CODE PIC X(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCwfReturnCode(final String cwfReturnCode) {
    this.cwfReturnCode = cwfReturnCode;
  }

  /**
   * Corresponds to {@code H-FINAL-AMT-WITHOUT-HDPA PIC 9(07)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFinalAmountWithoutHdpa() {
    return this.finalAmountWithoutHdpa;
  }

  /**
   * Corresponds to {@code H-FINAL-AMT-WITHOUT-HDPA PIC 9(07)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinalAmountWithoutHdpa(final BigDecimal finalAmountWithoutHdpa) {
    this.finalAmountWithoutHdpa = finalAmountWithoutHdpa;
  }

  /**
   * Corresponds to {@code H-FINAL-AMT-WITH-HDPA PIC 9(07)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFinalAmountWithHdpa() {
    return this.finalAmountWithHdpa;
  }

  /**
   * Corresponds to {@code H-FINAL-AMT-WITH-HDPA PIC 9(07)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinalAmountWithHdpa(final BigDecimal finalAmountWithHdpa) {
    this.finalAmountWithHdpa = finalAmountWithHdpa;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFinalAmountWithoutPpa() {
    return this.finalAmountWithoutPpa;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinalAmountWithoutPpa(final BigDecimal finalAmountWithoutPpa) {
    this.finalAmountWithoutPpa = finalAmountWithoutPpa;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFinalAmountWithPpa() {
    return this.finalAmountWithPpa;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinalAmountWithPpa(final BigDecimal finalAmountWithPpa) {
    this.finalAmountWithPpa = finalAmountWithPpa;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFinalAmountWithoutEtc() {
    return this.finalAmountWithoutEtc;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinalAmountWithoutEtc(final BigDecimal finalAmountWithoutEtc) {
    this.finalAmountWithoutEtc = finalAmountWithoutEtc;
  }

  /**
   * Corresponds to {@code H-PPS-FINAL-PAY-AMT PIC 9(07)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFinalPaymentAmount() {
    return this.finalPaymentAmount;
  }

  /**
   * Corresponds to {@code H-PPS-FINAL-PAY-AMT PIC 9(07)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinalPaymentAmount(final BigDecimal finalPaymentAmount) {
    this.finalPaymentAmount = finalPaymentAmount;
  }

  /**
   * Corresponds to {@code H-FULL-CLAIM-AMT PIC 9(07)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFullClaimAmount() {
    return this.fullClaimAmount;
  }

  /**
   * Corresponds to {@code H-FULL-CLAIM-AMT PIC 9(07)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFullClaimAmount(final BigDecimal fullClaimAmount) {
    this.fullClaimAmount = fullClaimAmount;
  }

  /**
   * Corresponds to {@code H-HEMO-EQUIV-DIAL-SESSIONS PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHemoEquivalentDialysisSessions() {
    return this.hemoEquivalentDialysisSessions;
  }

  /**
   * Corresponds to {@code H-HEMO-EQUIV-DIAL-SESSIONS PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHemoEquivalentDialysisSessions(final BigDecimal hemoEquivalentDialysisSessions) {
    this.hemoEquivalentDialysisSessions = hemoEquivalentDialysisSessions;
  }

  /**
   * Corresponds to {@code H-NETWORK-REDUCTION PIC 9(01)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNetworkReductionAmount() {
    return this.networkReductionAmount;
  }

  /**
   * Corresponds to {@code H-NETWORK-REDUCTION PIC 9(01)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNetworkReductionAmount(final BigDecimal networkReductionAmount) {
    this.networkReductionAmount = networkReductionAmount;
  }

  /**
   * Corresponds to {@code H-PATIENT-AGE PIC 9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getPatientAge() {
    return this.patientAge;
  }

  /**
   * Corresponds to {@code H-PATIENT-AGE PIC 9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientAge(final int patientAge) {
    this.patientAge = patientAge;
  }

  /**
   * Corresponds to {@code H-PER-DIEM-AMT-WITHOUT-HDPA PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPerDiemAmountWithoutHdpa() {
    return this.perDiemAmountWithoutHdpa;
  }

  /**
   * Corresponds to {@code H-PER-DIEM-AMT-WITHOUT-HDPA PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPerDiemAmountWithoutHdpa(final BigDecimal perDiemAmountWithoutHdpa) {
    this.perDiemAmountWithoutHdpa = perDiemAmountWithoutHdpa;
  }

  /**
   * Corresponds to {@code H-PER-DIEM-AMT-WITH-HDPA PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPerDiemAmountWithHdpa() {
    return this.perDiemAmountWithHdpa;
  }

  /**
   * Corresponds to {@code H-PER-DIEM-AMT-WITH-HDPA PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPerDiemAmountWithHdpa(final BigDecimal perDiemAmountWithHdpa) {
    this.perDiemAmountWithHdpa = perDiemAmountWithHdpa;
  }

  /**
   * Corresponds to {@code H-PER-DIEM-AMT-WITHOUT-HDPA PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPerDiemAmountWithoutEtc() {
    return this.perDiemAmountWithoutEtc;
  }

  /**
   * Corresponds to {@code H-PER-DIEM-AMT-WITHOUT-HDPA PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPerDiemAmountWithoutEtc(final BigDecimal perDiemAmountWithoutEtc) {
    this.perDiemAmountWithoutEtc = perDiemAmountWithoutEtc;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPerDiemAmountWithoutPpa() {
    return this.perDiemAmountWithoutPpa;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPerDiemAmountWithoutPpa(final BigDecimal perDiemAmountWithoutPpa) {
    this.perDiemAmountWithoutPpa = perDiemAmountWithoutPpa;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPerDiemAmountWithPpa() {
    return this.perDiemAmountWithPpa;
  }

  /**
   * CR12492 July 1, 2022 implementation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPerDiemAmountWithPpa(final BigDecimal perDiemAmountWithPpa) {
    this.perDiemAmountWithPpa = perDiemAmountWithPpa;
  }

  /**
   * Corresponds to {@code QIP-REDUCTION PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getQipReduction() {
    return this.qipReduction;
  }

  /**
   * Corresponds to {@code QIP-REDUCTION PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQipReduction(final BigDecimal qipReduction) {
    this.qipReduction = qipReduction;
  }

  /**
   * Corresponds to {@code H-TDAPA-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTdapaPayment() {
    return this.tdapaPayment;
  }

  /**
   * Corresponds to {@code H-TDAPA-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTdapaPayment(final BigDecimal tdapaPayment) {
    this.tdapaPayment = tdapaPayment;
  }

  /**
   * Corresponds to {@code H-TPNIES-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTpniesPayment() {
    return this.tpniesPayment;
  }

  /**
   * Corresponds to {@code H-TPNIES-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTpniesPayment(final BigDecimal tpniesPayment) {
    this.tpniesPayment = tpniesPayment;
  }

  /**
   * Corresponds to {@code H-BUN-ADJUSTED-BASE-WAGE-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledAdjustedBaseWageAmount() {
    return this.bundledAdjustedBaseWageAmount;
  }

  /**
   * Corresponds to {@code H-BUN-ADJUSTED-BASE-WAGE-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledAdjustedBaseWageAmount(final BigDecimal bundledAdjustedBaseWageAmount) {
    this.bundledAdjustedBaseWageAmount = bundledAdjustedBaseWageAmount;
  }

  /**
   * Corresponds to {@code H-BUN-AGE-FACTOR PIC PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledAgeAdjustmentFactor() {
    return this.bundledAgeAdjustmentFactor;
  }

  /**
   * Corresponds to {@code H-BUN-AGE-FACTOR PIC PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledAgeAdjustmentFactor(final BigDecimal bundledAgeAdjustmentFactor) {
    this.bundledAgeAdjustmentFactor = bundledAgeAdjustmentFactor;
  }

  /**
   * Corresponds to {@code H-BUN-BMI PIC 9(03)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledBmi() {
    return this.bundledBmi;
  }

  /**
   * Corresponds to {@code H-BUN-BMI PIC 9(03)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledBmi(final BigDecimal bundledBmi) {
    this.bundledBmi = bundledBmi;
  }

  /**
   * Corresponds to {@code H-BUN-BMI-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledBmiFactor() {
    return this.bundledBmiFactor;
  }

  /**
   * Corresponds to {@code H-BUN-BMI-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledBmiFactor(final BigDecimal bundledBmiFactor) {
    this.bundledBmiFactor = bundledBmiFactor;
  }

  /**
   * Corresponds to {@code H-BUN-BSA PIC 9(03)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledBsa() {
    return this.bundledBsa;
  }

  /**
   * Corresponds to {@code H-BUN-BSA PIC 9(03)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledBsa(final BigDecimal bundledBsa) {
    this.bundledBsa = bundledBsa;
  }

  /**
   * Corresponds to {@code H-BUN-BSA-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledBsaFactor() {
    return this.bundledBsaFactor;
  }

  /**
   * Corresponds to {@code H-BUN-BSA-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledBsaFactor(final BigDecimal bundledBsaFactor) {
    this.bundledBsaFactor = bundledBsaFactor;
  }

  /**
   * Corresponds to {@code H-BUN-COMORBID-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledComorbidityMultiplier() {
    return this.bundledComorbidityMultiplier;
  }

  /**
   * Corresponds to {@code H-BUN-COMORBID-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledComorbidityMultiplier(final BigDecimal bundledComorbidityMultiplier) {
    this.bundledComorbidityMultiplier = bundledComorbidityMultiplier;
  }

  /**
   * Corresponds to {@code H-BUN-LOW-VOL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledLowVolumeMultiplier() {
    return this.bundledLowVolumeMultiplier;
  }

  /**
   * Corresponds to {@code H-BUN-LOW-VOL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledLowVolumeMultiplier(final BigDecimal bundledLowVolumeMultiplier) {
    this.bundledLowVolumeMultiplier = bundledLowVolumeMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledLowVolumeTierOneMultiplier() {
    return this.bundledLowVolumeTierOneMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledLowVolumeTierOneMultiplier(final BigDecimal bundledLowVolumeTierOneMultiplier) {
    this.bundledLowVolumeTierOneMultiplier = bundledLowVolumeTierOneMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledLowVolumeTierTwoMultiplier() {
    return this.bundledLowVolumeTierTwoMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledLowVolumeTierTwoMultiplier(final BigDecimal bundledLowVolumeTierTwoMultiplier) {
    this.bundledLowVolumeTierTwoMultiplier = bundledLowVolumeTierTwoMultiplier;
  }

  /**
   * Corresponds to {@code H-BUN-NAT-LABOR-AMT PIC 9(04)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledNationalLaborAmount() {
    return this.bundledNationalLaborAmount;
  }

  /**
   * Corresponds to {@code H-BUN-NAT-LABOR-AMT PIC 9(04)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledNationalLaborAmount(final BigDecimal bundledNationalLaborAmount) {
    this.bundledNationalLaborAmount = bundledNationalLaborAmount;
  }

  /**
   * Corresponds to {@code H-BUN-NAT-NONLABOR-AMT PIC 9(04)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledNationalNonLaborAmount() {
    return this.bundledNationalNonLaborAmount;
  }

  /**
   * Corresponds to {@code H-BUN-NAT-NONLABOR-AMT PIC 9(04)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledNationalNonLaborAmount(final BigDecimal bundledNationalNonLaborAmount) {
    this.bundledNationalNonLaborAmount = bundledNationalNonLaborAmount;
  }

  /**
   * Corresponds to {@code H-BUN-BASE-WAGE-AMT PIC 9(04)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledBaseWageAmount() {
    return this.bundledBaseWageAmount;
  }

  /**
   * Corresponds to {@code H-BUN-BASE-WAGE-AMT PIC 9(04)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledBaseWageAmount(final BigDecimal bundledBaseWageAmount) {
    this.bundledBaseWageAmount = bundledBaseWageAmount;
  }

  /**
   * Corresponds to {@code H-BUN-ONSET-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledOnsetFactor() {
    return this.bundledOnsetFactor;
  }

  /**
   * Corresponds to {@code H-BUN-ONSET-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledOnsetFactor(final BigDecimal bundledOnsetFactor) {
    this.bundledOnsetFactor = bundledOnsetFactor;
  }

  /**
   * Corresponds to {@code H-BUN-RURAL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledRuralMultiplier() {
    return this.bundledRuralMultiplier;
  }

  /**
   * Corresponds to {@code H-BUN-RURAL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledRuralMultiplier(final BigDecimal bundledRuralMultiplier) {
    this.bundledRuralMultiplier = bundledRuralMultiplier;
  }

  /**
   * Corresponds to {@code H-BUN-WAGE-ADJ-TRAINING-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledWageAdjustedTrainingAmount() {
    return this.bundledWageAdjustedTrainingAmount;
  }

  /**
   * Corresponds to {@code H-BUN-WAGE-ADJ-TRAINING-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledWageAdjustedTrainingAmount(final BigDecimal bundledWageAdjustedTrainingAmount) {
    this.bundledWageAdjustedTrainingAmount = bundledWageAdjustedTrainingAmount;
  }

  /**
   * Corresponds to {@code BUN-CBSA-W-INDEX PIC 9(02)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledWageIndex() {
    return this.bundledWageIndex;
  }

  /**
   * Corresponds to {@code BUN-CBSA-W-INDEX PIC 9(02)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledWageIndex(final BigDecimal bundledWageIndex) {
    this.bundledWageIndex = bundledWageIndex;
  }

  /**
   * Corresponds to {@code H-LV-BUN-ADJUST-BASE-WAGE-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowVolumeBundledAdjustedBaseWageAmount() {
    return this.lowVolumeBundledAdjustedBaseWageAmount;
  }

  /**
   * Corresponds to {@code H-LV-BUN-ADJUST-BASE-WAGE-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumeBundledAdjustedBaseWageAmount(final BigDecimal lowVolumeBundledAdjustedBaseWageAmount) {
    this.lowVolumeBundledAdjustedBaseWageAmount = lowVolumeBundledAdjustedBaseWageAmount;
  }

  /**
   * Corresponds to {@code H-LV-OUT-CM-ADJ-PREDICT-M-TRT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt() {
    return this.lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt;
  }

  /**
   * Corresponds to {@code H-LV-OUT-CM-ADJ-PREDICT-M-TRT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt(final BigDecimal lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt) {
    this.lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt = lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt;
  }

  /**
   * Corresponds to {@code H-LV-PPS-FINAL-PAY-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowVolumeFinalPaymentAmount() {
    return this.lowVolumeFinalPaymentAmount;
  }

  /**
   * Corresponds to {@code H-LV-PPS-FINAL-PAY-AMT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumeFinalPaymentAmount(final BigDecimal lowVolumeFinalPaymentAmount) {
    this.lowVolumeFinalPaymentAmount = lowVolumeFinalPaymentAmount;
  }

  /**
   * Corresponds to {@code H-LV-OUT-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowVolumeOutlierPayment() {
    return this.lowVolumeOutlierPayment;
  }

  /**
   * Corresponds to {@code H-LV-OUT-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumeOutlierPayment(final BigDecimal lowVolumeOutlierPayment) {
    this.lowVolumeOutlierPayment = lowVolumeOutlierPayment;
  }

  /**
   * Corresponds to {@code H-LV-OUT-PREDICTED-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowVolumeOutlierPredictedMap() {
    return this.lowVolumeOutlierPredictedMap;
  }

  /**
   * Corresponds to {@code H-LV-OUT-PREDICTED-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumeOutlierPredictedMap(final BigDecimal lowVolumeOutlierPredictedMap) {
    this.lowVolumeOutlierPredictedMap = lowVolumeOutlierPredictedMap;
  }

  /**
   * Corresponds to {@code H-LV-OUT-PREDICT-SERVICES-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowVolumeOutlierPredictedSvcsMap() {
    return this.lowVolumeOutlierPredictedSvcsMap;
  }

  /**
   * Corresponds to {@code H-LV-OUT-PREDICT-SERVICES-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumeOutlierPredictedSvcsMap(final BigDecimal lowVolumeOutlierPredictedSvcsMap) {
    this.lowVolumeOutlierPredictedSvcsMap = lowVolumeOutlierPredictedSvcsMap;
  }

  /**
   * Corresponds to {@code H-OUT-ADJ-AVG-MAP-AMT PIC 9(03)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierAdjustedAverageMapAmount() {
    return this.outlierAdjustedAverageMapAmount;
  }

  /**
   * Corresponds to {@code H-OUT-ADJ-AVG-MAP-AMT PIC 9(03)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierAdjustedAverageMapAmount(final BigDecimal outlierAdjustedAverageMapAmount) {
    this.outlierAdjustedAverageMapAmount = outlierAdjustedAverageMapAmount;
  }

  /**
   * Corresponds to {@code H-OUT-AGE-FACTOR PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierAgeAdjustmentFactor() {
    return this.outlierAgeAdjustmentFactor;
  }

  /**
   * Corresponds to {@code H-OUT-AGE-FACTOR PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierAgeAdjustmentFactor(final BigDecimal outlierAgeAdjustmentFactor) {
    this.outlierAgeAdjustmentFactor = outlierAgeAdjustmentFactor;
  }

  /**
   * Corresponds to {@code H-OUT-BMI PIC 9(03)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBmi() {
    return this.outlierBmi;
  }

  /**
   * Corresponds to {@code H-OUT-BMI PIC 9(03)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBmi(final BigDecimal outlierBmi) {
    this.outlierBmi = outlierBmi;
  }

  /**
   * Corresponds to {@code H-OUT-BMI-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBmiFactor() {
    return this.outlierBmiFactor;
  }

  /**
   * Corresponds to {@code H-OUT-BMI-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBmiFactor(final BigDecimal outlierBmiFactor) {
    this.outlierBmiFactor = outlierBmiFactor;
  }

  /**
   * Corresponds to {@code H-OUT-BSA PIC 9(03)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBsa() {
    return this.outlierBsa;
  }

  /**
   * Corresponds to {@code H-OUT-BSA PIC 9(03)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBsa(final BigDecimal outlierBsa) {
    this.outlierBsa = outlierBsa;
  }

  /**
   * Corresponds to {@code H-OUT-BSA-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBsaFactor() {
    return this.outlierBsaFactor;
  }

  /**
   * Corresponds to {@code H-OUT-BSA-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBsaFactor(final BigDecimal outlierBsaFactor) {
    this.outlierBsaFactor = outlierBsaFactor;
  }

  /**
   * Corresponds to {@code H-OUT-CM-ADJ-PREDICT-MAP-TRT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierCaseMixAdjPredictedMapTrt() {
    return this.outlierCaseMixAdjPredictedMapTrt;
  }

  /**
   * Corresponds to {@code H-OUT-CM-ADJ-PREDICT-MAP-TRT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierCaseMixAdjPredictedMapTrt(final BigDecimal outlierCaseMixAdjPredictedMapTrt) {
    this.outlierCaseMixAdjPredictedMapTrt = outlierCaseMixAdjPredictedMapTrt;
  }

  /**
   * Corresponds to {@code H-OUT-COMORBID-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierComorbidityMultiplier() {
    return this.outlierComorbidityMultiplier;
  }

  /**
   * Corresponds to {@code H-OUT-COMORBID-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierComorbidityMultiplier(final BigDecimal outlierComorbidityMultiplier) {
    this.outlierComorbidityMultiplier = outlierComorbidityMultiplier;
  }

  /**
   * Corresponds to {@code H-OUT-HEMO-EQUIV-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierHemoEquivalentPayment() {
    return this.outlierHemoEquivalentPayment;
  }

  /**
   * Corresponds to {@code H-OUT-HEMO-EQUIV-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierHemoEquivalentPayment(final BigDecimal outlierHemoEquivalentPayment) {
    this.outlierHemoEquivalentPayment = outlierHemoEquivalentPayment;
  }

  /**
   * Corresponds to {@code H-OUT-IMPUTED-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierImputedMapAmount() {
    return this.outlierImputedMapAmount;
  }

  /**
   * Corresponds to {@code H-OUT-IMPUTED-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierImputedMapAmount(final BigDecimal outlierImputedMapAmount) {
    this.outlierImputedMapAmount = outlierImputedMapAmount;
  }

  /**
   * Corresponds to {@code H-OUT-FIX-DOLLAR-LOSS PIC 9(04)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierFixedDollarLoss() {
    return this.outlierFixedDollarLoss;
  }

  /**
   * Corresponds to {@code H-OUT-FIX-DOLLAR-LOSS PIC 9(04)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierFixedDollarLoss(final BigDecimal outlierFixedDollarLoss) {
    this.outlierFixedDollarLoss = outlierFixedDollarLoss;
  }

  /**
   * Corresponds to {@code H-OUT-LOSS-SHARING-PCT PIC 9(01)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierLossSharingPercentage() {
    return this.outlierLossSharingPercentage;
  }

  /**
   * Corresponds to {@code H-OUT-LOSS-SHARING-PCT PIC 9(01)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierLossSharingPercentage(final BigDecimal outlierLossSharingPercentage) {
    this.outlierLossSharingPercentage = outlierLossSharingPercentage;
  }

  /**
   * Corresponds to {@code H-OUT-LOW-VOL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierLowVolumeMultiplier() {
    return this.outlierLowVolumeMultiplier;
  }

  /**
   * Corresponds to {@code H-OUT-LOW-VOL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierLowVolumeMultiplier(final BigDecimal outlierLowVolumeMultiplier) {
    this.outlierLowVolumeMultiplier = outlierLowVolumeMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierLowVolumeTierOneMultiplier() {
    return this.outlierLowVolumeTierOneMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierLowVolumeTierOneMultiplier(final BigDecimal outlierLowVolumeTierOneMultiplier) {
    this.outlierLowVolumeTierOneMultiplier = outlierLowVolumeTierOneMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierLowVolumeTierTwoMultiplier() {
    return this.outlierLowVolumeTierTwoMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierLowVolumeTierTwoMultiplier(final BigDecimal outlierLowVolumeTierTwoMultiplier) {
    this.outlierLowVolumeTierTwoMultiplier = outlierLowVolumeTierTwoMultiplier;
  }

  /**
   * Corresponds to {@code H-OUT-ONSET-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierOnsetFactor() {
    return this.outlierOnsetFactor;
  }

  /**
   * Corresponds to {@code H-OUT-ONSET-FACTOR PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierOnsetFactor(final BigDecimal outlierOnsetFactor) {
    this.outlierOnsetFactor = outlierOnsetFactor;
  }

  /**
   * Corresponds to {@code H-OUT-RURAL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierRuralMultiplier() {
    return this.outlierRuralMultiplier;
  }

  /**
   * Corresponds to {@code H-OUT-RURAL-MULTIPLIER PIC 9(01)V9(03)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierRuralMultiplier(final BigDecimal outlierRuralMultiplier) {
    this.outlierRuralMultiplier = outlierRuralMultiplier;
  }

  /**
   * Corresponds to {@code H-OUT-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPayment() {
    return this.outlierPayment;
  }

  /**
   * Corresponds to {@code H-OUT-PAYMENT PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPayment(final BigDecimal outlierPayment) {
    this.outlierPayment = outlierPayment;
  }

  /**
   * Corresponds to {@code H-OUT-PREDICTED-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPredictedMapAmount() {
    return this.outlierPredictedMapAmount;
  }

  /**
   * Corresponds to {@code H-OUT-PREDICTED-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPredictedMapAmount(final BigDecimal outlierPredictedMapAmount) {
    this.outlierPredictedMapAmount = outlierPredictedMapAmount;
  }

  /**
   * Corresponds to {@code H-OUT-PREDICTED-SERVICES-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPredictedSvcsMapAmount() {
    return this.outlierPredictedSvcsMapAmount;
  }

  /**
   * Corresponds to {@code H-OUT-PREDICTED-SERVICES-MAP PIC 9(07)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPredictedSvcsMapAmount(final BigDecimal outlierPredictedSvcsMapAmount) {
    this.outlierPredictedSvcsMapAmount = outlierPredictedSvcsMapAmount;
  }

  /**
   * Corresponds to {@code ACUTE-COMORBID-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isAcuteComorbidityFound() {
    return this.acuteComorbidityFound;
  }

  /**
   * Corresponds to {@code ACUTE-COMORBID-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAcuteComorbidityFound(final boolean acuteComorbidityFound) {
    this.acuteComorbidityFound = acuteComorbidityFound;
  }

  /**
   * Corresponds to {@code CHRONIC-COMORBID-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isChronicComorbidityFound() {
    return this.chronicComorbidityFound;
  }

  /**
   * Corresponds to {@code CHRONIC-COMORBID-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setChronicComorbidityFound(final boolean chronicComorbidityFound) {
    this.chronicComorbidityFound = chronicComorbidityFound;
  }

  /**
   * Corresponds to {@code LOW-BMI-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isLowBmiClaim() {
    return this.lowBmiClaim;
  }

  /**
   * Corresponds to {@code LOW-BMI-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowBmiClaim(final boolean lowBmiClaim) {
    this.lowBmiClaim = lowBmiClaim;
  }

  /**
   * Corresponds to {@code LOW-VOLUME-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isLowVolumeClaim() {
    return this.lowVolumeClaim;
  }

  /**
   * Corresponds to {@code LOW-VOLUME-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumeClaim(final boolean lowVolumeClaim) {
    this.lowVolumeClaim = lowVolumeClaim;
  }

  /**
   * Corresponds to {@code OUTLIER-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isOutlierClaim() {
    return this.outlierClaim;
  }

  /**
   * Corresponds to {@code OUTLIER-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierClaim(final boolean outlierClaim) {
    this.outlierClaim = outlierClaim;
  }

  /**
   * Corresponds to {@code PEDIATRIC-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isPediatricClaim() {
    return this.pediatricClaim;
  }

  /**
   * Corresponds to {@code PEDIATRIC-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPediatricClaim(final boolean pediatricClaim) {
    this.pediatricClaim = pediatricClaim;
  }

  /**
   * Corresponds to {@code ONSET-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isOnsetRecent() {
    return this.onsetRecent;
  }

  /**
   * Corresponds to {@code ONSET-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOnsetRecent(final boolean onsetRecent) {
    this.onsetRecent = onsetRecent;
  }

  /**
   * Corresponds to {@code TRAINING-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isTrainingClaim() {
    return this.trainingClaim;
  }

  /**
   * Corresponds to {@code TRAINING-TRACK PIC X(01)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTrainingClaim(final boolean trainingClaim) {
    this.trainingClaim = trainingClaim;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isAki84() {
    return this.aki84;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAki84(final boolean aki84) {
    this.aki84 = aki84;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isEsrdFacility() {
    return this.esrdFacility;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEsrdFacility(final boolean esrdFacility) {
    this.esrdFacility = esrdFacility;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isAkiTraining8473() {
    return this.akiTraining8473;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAkiTraining8473(final boolean akiTraining8473) {
    this.akiTraining8473 = akiTraining8473;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isAkiHome8474() {
    return this.akiHome8474;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAkiHome8474(final boolean akiHome8474) {
    this.akiHome8474 = akiHome8474;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isAkiRetraining8487() {
    return this.akiRetraining8487;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAkiRetraining8487(final boolean akiRetraining8487) {
    this.akiRetraining8487 = akiRetraining8487;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isEsrdTraining73() {
    return this.esrdTraining73;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEsrdTraining73(final boolean esrdTraining73) {
    this.esrdTraining73 = esrdTraining73;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isEsrdHome74() {
    return this.esrdHome74;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEsrdHome74(final boolean esrdHome74) {
    this.esrdHome74 = esrdHome74;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isEsrdBackup76() {
    return this.esrdBackup76;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEsrdBackup76(final boolean esrdBackup76) {
    this.esrdBackup76 = esrdBackup76;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isAkiFacility84() {
    return this.akiFacility84;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAkiFacility84(final boolean akiFacility84) {
    this.akiFacility84 = akiFacility84;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isEsrdRetraining87() {
    return this.esrdRetraining87;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEsrdRetraining87(final boolean esrdRetraining87) {
    this.esrdRetraining87 = esrdRetraining87;
  }
}
