/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;

public class InstrumentedAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final MetricRegistry registry;
    public static final String DEFAULT_REGISTRY = "logback-metrics";
    public static final String REGISTRY_PROPERTY_NAME = "metrics.logback.registry";
    private Meter all;
    private Meter trace;
    private Meter debug;
    private Meter info;
    private Meter warn;
    private Meter error;

    public InstrumentedAppender() {
        this(System.getProperty(REGISTRY_PROPERTY_NAME, DEFAULT_REGISTRY));
    }

    public InstrumentedAppender(String registryName) {
        this(SharedMetricRegistries.getOrCreate(registryName));
    }

    public InstrumentedAppender(MetricRegistry registry) {
        this.registry = registry;
        this.setName(Appender.class.getName());
    }

    @Override
    public void start() {
        this.all = this.registry.meter(MetricRegistry.name(this.getName(), "all"));
        this.trace = this.registry.meter(MetricRegistry.name(this.getName(), "trace"));
        this.debug = this.registry.meter(MetricRegistry.name(this.getName(), "debug"));
        this.info = this.registry.meter(MetricRegistry.name(this.getName(), "info"));
        this.warn = this.registry.meter(MetricRegistry.name(this.getName(), "warn"));
        this.error = this.registry.meter(MetricRegistry.name(this.getName(), "error"));
        super.start();
    }

    @Override
    protected void append(ILoggingEvent event) {
        this.all.mark();
        switch (event.getLevel().toInt()) {
            case 5000: {
                this.trace.mark();
                break;
            }
            case 10000: {
                this.debug.mark();
                break;
            }
            case 20000: {
                this.info.mark();
                break;
            }
            case 30000: {
                this.warn.mark();
                break;
            }
            case 40000: {
                this.error.mark();
                break;
            }
        }
    }
}

