/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.contract;

import com.fasterxml.jackson.databind.type.SimpleType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerElementModelConverter
implements ModelConverter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerElementModelConverter.class);
    private final Map<String, Map<Class<?>, Annotation[]>> propertyRefs = new HashMap();

    @Override
    public Schema<?> resolve(io.swagger.v3.core.converter.AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (type.getType() instanceof SimpleType) {
            Class<?> rawType = ((SimpleType)type.getType()).getRawClass();
            if (!rawType.isPrimitive() && !StringUtils.startsWithAny(rawType.getPackage().getName(), "java.lang", "java.math", "java.time")) {
                LOGGER.debug("Obtaining annotations for type '{}'", (Object)rawType.getSimpleName());
                Arrays.stream(rawType.getDeclaredFields()).forEach(this::processFieldAnnotations);
            } else {
                Map<Class<?>, Annotation[]> additionalAnnotations = this.propertyRefs.get(type.getPropertyName());
                if (null != additionalAnnotations && additionalAnnotations.containsKey(rawType)) {
                    type.setCtxAnnotations(ArrayUtils.addAll(type.getCtxAnnotations(), additionalAnnotations.get(rawType)));
                }
                LOGGER.debug("Updated annotations for '{}' on property '{}'", (Object)rawType.getSimpleName(), (Object)type.getPropertyName());
            }
        }
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    private void processFieldAnnotations(Field field) {
        Map fieldAnnotations = this.propertyRefs.computeIfAbsent(field.getName(), k -> new HashMap());
        if (field.getType().isArray()) {
            LOGGER.debug("Obtaining annotations for array field '{}'", (Object)field.getName());
            fieldAnnotations.put(field.getType().getComponentType(), (Annotation[])Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().getPackageName().equals("javax.validation.constraints")).toArray(Annotation[]::new));
            return;
        }
        if (field.getGenericType() instanceof ParameterizedType) {
            AnnotatedType[] reflAnnotatedTypes;
            LOGGER.debug("Obtaining annotations for parameterized field '{}'", (Object)field.getName());
            for (AnnotatedType annotatedParameter : reflAnnotatedTypes = ((AnnotatedParameterizedType)field.getAnnotatedType()).getAnnotatedActualTypeArguments()) {
                LOGGER.debug("Extracted annotations for parameterized field '{}' for type '{}'", (Object)field.getName(), (Object)((Class)annotatedParameter.getType()));
                fieldAnnotations.put((Class)annotatedParameter.getType(), annotatedParameter.getDeclaredAnnotations());
            }
        }
    }
}

