/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.resources;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import gov.cms.fiss.pricers.common.api.AmbulatoryPaymentClassificationRateData;
import gov.cms.fiss.pricers.common.api.AmbulatoryPaymentClassificationRateResponse;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.api.validation.ValidApc;
import gov.cms.fiss.pricers.common.application.OpenApiApplicationConfiguration;
import gov.cms.fiss.pricers.common.application.Rfc7807Support;
import gov.cms.fiss.pricers.common.application.resources.ApcTableEntryCsvFormatter;
import gov.cms.fiss.pricers.common.application.resources.BaseRetrievalResource;
import io.dropwizard.jersey.jsr310.LocalDateParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.time.LocalDate;
import java.util.List;
import java.util.function.IntFunction;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ObjectUtils;

@Path(value="/v1/apc-rates")
public class ApcRateResource
extends BaseRetrievalResource<AmbulatoryPaymentClassificationRateData, AmbulatoryPaymentClassificationRateResponse> {
    public ApcRateResource(OpenApiApplicationConfiguration pricerConfiguration, IntFunction<List<AmbulatoryPaymentClassificationRateData>> extractionFunction) {
        super(pricerConfiguration, () -> (CsvMapper)DEFAULT_CSV_MAPPER.copy().addMixIn(AmbulatoryPaymentClassificationRateData.class, ApcTableEntryCsvFormatter.class), csvMapper -> CsvSchema.builder().addColumn("ambulatoryPaymentClassificationCode").addColumn("effectiveDate", CsvSchema.ColumnType.STRING).addColumn("statusIndicator", CsvSchema.ColumnType.STRING).addColumn("paymentRate", CsvSchema.ColumnType.NUMBER).addColumn("minimumCoinsuranceRate", CsvSchema.ColumnType.NUMBER).addColumn("nationalCoinsuranceRate", CsvSchema.ColumnType.NUMBER).build().withHeader(), AmbulatoryPaymentClassificationRateResponse::new, extractionFunction);
    }

    @GET
    @Operation(summary="Retrieves all payment & coinsurance rate data for a given fiscal year.", description="Retrieves all ambulatory payment classification (APC) rate data for all effective dates within the provided fiscal year.", responses={@ApiResponse(responseCode="200", description="The matching ambulatory payment classification (APC) rate data.", content={@Content(mediaType="application/json", schema=@Schema(implementation=AmbulatoryPaymentClassificationRateData.class))}), @ApiResponse(responseCode="400", description="Invalid input provided. Please correct the indicated issues and re-submit your request.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error related to the parsing failure.", name="fieldValidationFailure", summary="Invalid request content.", value="{\n    \"status\": 400,\n    \"violations\": [\n        {\n            \"field\": \"findAll.path param year\",\n            \"message\": \"must be greater than or equal to 2000\"\n        }\n    ],\n    \"title\": \"Constraint Violation\"\n}")})}), @ApiResponse(responseCode="404", description="Resource not found.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs if the requested resource doesn't exist.", name="missingResource", summary="Resource not found.", value="{\n    \"title\": \"Not Found\",\n    \"status\": 404,\n    \"detail\": \"Year not in supported list.\"\n}")})}), @ApiResponse(responseCode="406", description="Occurs when media type requested isn't supported.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs media type requested isn't supported.", name="unsupportedMediaType", summary="An unsupported media type was requested.", value="{\n    \"title\": \"Not Acceptable\",\n    \"status\": 406,\n    \"detail\": \"*/* is not supported. Must be one of: application/json, text/csv\"\n}")})}), @ApiResponse(responseCode="500", description="Internal pricer error. This is usually the result of an internal issue that the client cannot resolve.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error information.", name="internalServerError", summary="Internal processing error", value="{\n    \"title\": \"Internal Pricer Exception\",\n    \"status\": 500,\n    \"detail\": \"Null pointer exception\",\n    \"errorMessage\": \"Unexpected exception while executing pricer\"\n}")})})})
    @Path(value="{year}")
    @Produces(value={"application/json", "text/csv"})
    @Rfc7807Support
    @Timed
    public Response getAllForYear(@Max(value=9999L) @Min(value=2000L) @NotNull @PathParam(value="year") @Parameter(description="The fiscal year for which data will be retrieved.") @Max(value=9999L) @Min(value=2000L) @NotNull int year, @HeaderParam(value="Accept") String contentType) throws YearNotImplementedException {
        return this.getPerYearEntries(year, contentType);
    }

    @GET
    @Operation(summary="Retrieve all matching ambulatory payment classification (APC) rate data for a given year.", description="Returns the data for a specific APC code for matching effective dates within the provided fiscal year.", responses={@ApiResponse(responseCode="200", description="The matching ambulatory payment classification (APC) rate data.", content={@Content(mediaType="application/json", schema=@Schema(implementation=AmbulatoryPaymentClassificationRateResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input provided. Please correct the indicated issues and re-submit your request.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error related to the parsing failure.", name="fieldValidationFailure", summary="Invalid request content.", value="{\n    \"status\": 400,\n    \"violations\": [\n        {\n            \"field\": \"findAll.path param year\",\n            \"message\": \"must be greater than or equal to 2000\"\n        }\n    ],\n    \"title\": \"Constraint Violation\"\n}")})}), @ApiResponse(responseCode="404", description="Resource not found.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs if the requested resource doesn't exist.", name="missingResource", summary="Resource not found.", value="{\n    \"title\": \"Not Found\",\n    \"status\": 404,\n    \"detail\": \"Year not in supported list.\"\n}")})}), @ApiResponse(responseCode="406", description="Occurs when media type requested isn't supported.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs media type requested isn't supported.", name="unsupportedMediaType", summary="An unsupported media type was requested.", value="{\n    \"title\": \"Not Acceptable\",\n    \"status\": 406,\n    \"detail\": \"*/* not supported. Must be one of: application/json, text/csv\"\n}")})}), @ApiResponse(responseCode="500", description="Internal pricer error. This is usually the result of an internal issue that the client cannot resolve.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error information.", name="internalServerError", summary="Internal processing error", value="{\n    \"title\": \"Internal Pricer Exception\",\n    \"status\": 500,\n    \"detail\": \"Null pointer exception\",\n    \"errorMessage\": \"Unexpected exception while executing pricer\"\n}")})})})
    @Path(value="{year}/{apcCode}")
    @Produces(value={"application/json"})
    @Rfc7807Support
    @Timed
    public Response getByCodeForYear(@Max(value=9999L) @Min(value=2000L) @NotNull @Parameter(description="The fiscal year for which data will be retrieved.") @PathParam(value="year") @Max(value=9999L) @Min(value=2000L) @NotNull int year, @NotNull @Parameter(description="The APC for which data will be retrieved.", example="04321") @PathParam(value="apcCode") @ValidApc String apcCode, @Parameter(description="Filters data so that only the APC data effective as of the provided date will be returned; if omitted, all values for the year will be returned.", example="2020-04-01", schema=@Schema(implementation=LocalDate.class)) @QueryParam(value="effectiveDate") LocalDateParam effectiveDate) throws YearNotImplementedException {
        return super.findExactMatch(year, apcCode, effectiveDate);
    }

    @GET
    @Operation(summary="Retrieve all matching ambulatory payment classification (APC) within the given date range.", description="Returns the data for a specific ambulatory payment classification (APC) for matching within the given date range, ordered by descending date.", responses={@ApiResponse(responseCode="200", description="The matching ambulatory payment classification (APC) rate data.", content={@Content(mediaType="application/json", schema=@Schema(implementation=AmbulatoryPaymentClassificationRateResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input provided. Please correct the indicated issues and re-submit your request.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error related to the parsing failure.", name="fieldValidationFailure", summary="Invalid request content.", value="{\n    \"status\": 400,\n    \"violations\": [\n        {\n            \"field\": \"findAll.path param year\",\n            \"message\": \"must be greater than or equal to 2000\"\n        }\n    ],\n    \"title\": \"Constraint Violation\"\n}")})}), @ApiResponse(responseCode="404", description="Resource not found.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs if the requested resource doesn't exist.", name="missingResource", summary="Resource not found.", value="{\n    \"title\": \"Not Found\",\n    \"status\": 404,\n    \"detail\": \"Year not in supported list.\"\n}")})}), @ApiResponse(responseCode="406", description="Occurs when media type requested isn't supported.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs media type requested isn't supported.", name="unsupportedMediaType", summary="An unsupported media type was requested.", value="{\n    \"title\": \"Not Acceptable\",\n    \"status\": 406,\n    \"detail\": \"*/* not supported. Must be one of: application/json, text/csv\"\n}")})}), @ApiResponse(responseCode="500", description="Internal pricer error. This is usually the result of an internal issue that the client cannot resolve.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error information.", name="internalServerError", summary="Internal processing error", value="{\n    \"title\": \"Internal Pricer Exception\",\n    \"status\": 500,\n    \"detail\": \"Null pointer exception\",\n    \"errorMessage\": \"Unexpected exception while executing pricer\"\n}")})})})
    @Path(value="find-in-range/{apcCode}")
    @Produces(value={"application/json"})
    @Rfc7807Support
    @Timed
    public Response findByCode(@NotNull @Parameter(description="The APC for which data will be retrieved.", example="04321") @PathParam(value="apcCode") @ValidApc String apcCode, @Parameter(description="The maximum number of entries to obtain for this ambulatory payment classification code. Defaults to 1.", example="1") @QueryParam(value="limit") @Max(value=20L) @Min(value=1L) @Max(value=20L) @Min(value=1L) Integer limit, @Parameter(description="Filter data so that only data after the date given will be returned. By default, the provided date is included in the search. Defaults to the beginning of the earliest supported pricer year.", example="2020-04-01", schema=@Schema(implementation=LocalDate.class)) @QueryParam(value="after") LocalDateParam afterDate, @Parameter(description="Filter data so that only data before the date given will be returned. By default, the provided date is included in the search. Defaults to the current date.", example="2020-04-01", schema=@Schema(implementation=LocalDate.class)) @QueryParam(value="before") LocalDateParam beforeDate, @Parameter(description="Indicates whether the after date should be exclusive. Defaults to false.", example="false") @QueryParam(value="exclusiveAfter") Boolean exclusiveAfter, @Parameter(description="Indicates whether the before date should be exclusive. Defaults to false.", example="false") @QueryParam(value="exclusiveBefore") Boolean exclusiveBefore) {
        return this.findByCodeAndDateRange(apcCode, ObjectUtils.defaultIfNull(limit, 1), afterDate, beforeDate, ObjectUtils.defaultIfNull(exclusiveAfter, false), ObjectUtils.defaultIfNull(exclusiveBefore, false));
    }

    @Override
    protected LocalDate getDate(AmbulatoryPaymentClassificationRateData entry) {
        return entry.getEffectiveDate();
    }

    @Override
    protected String getKey(AmbulatoryPaymentClassificationRateData entry) {
        return entry.getAmbulatoryPaymentClassificationCode();
    }
}

