/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import org.apache.commons.lang3.StringUtils;

public class DetermineQipReduction
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        OutpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.isNotEmpty(providerData.getHospitalQualityIndicator())) {
            switch (providerData.getHospitalQualityIndicator()) {
                case "1": {
                    calculationContext.setQipReduction(EsrdPricerContext.QIP_REDUCTION_HALF_PCT);
                    break;
                }
                case "2": {
                    calculationContext.setQipReduction(EsrdPricerContext.QIP_REDUCTION_ONE_PCT);
                    break;
                }
                case "3": {
                    calculationContext.setQipReduction(EsrdPricerContext.QIP_REDUCTION_ONE_AND_HALF_PCT);
                    break;
                }
                case "4": {
                    calculationContext.setQipReduction(EsrdPricerContext.QIP_REDUCTION_TWO_PCT);
                    break;
                }
                default: {
                    calculationContext.setQipReduction(EsrdPricerContext.QIP_REDUCTION_NONE);
                }
            }
        }
    }
}

