/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2020_2.move_results;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.BundledPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdPaymentData;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.rules.move_results.MoveBaseResults;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MoveBaseResults2020Dot2
extends MoveBaseResults {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        super.calculate(calculationContext);
        this.applyHdpaEtcAdjustment(calculationContext);
    }

    protected void applyHdpaEtcAdjustment(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        BundledPaymentData bundledData = calculationContext.getBundledData();
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        if (!calculationContext.isAki84()) {
            if (calculationContext.hasDemoCode("94")) {
                bundledData.setFullPaymentRate(calculationContext.getFinalAmountWithHdpa());
                paymentData.setAdjustedBaseWageBeforeEtcHdpaAmount(calculationContext.getFinalAmountWithoutHdpa());
            } else {
                bundledData.setFullPaymentRate(calculationContext.getFinalAmountWithoutHdpa());
                paymentData.setAdjustedBaseWageBeforeEtcHdpaAmount(BigDecimal.ZERO);
            }
        }
    }

    @Override
    protected void adjustOutlierForQip(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        OutpatientProviderData providerData = calculationContext.getProviderData();
        BundledPaymentData bundledData = calculationContext.getBundledData();
        if (!calculationContext.isAki84() && null != providerData.getHospitalQualityIndicator()) {
            bundledData.setBlendedCompositeRate(BigDecimalUtils.defaultValue(bundledData.getBlendedCompositeRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            bundledData.setFullCompositeRate(BigDecimalUtils.defaultValue(bundledData.getFullCompositeRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            bundledData.setBlendedPaymentRate(BigDecimalUtils.defaultValue(bundledData.getBlendedPaymentRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            bundledData.setBlendedOutlierRate(BigDecimalUtils.defaultValue(bundledData.getBlendedOutlierRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            calculationContext.setFinalAmountWithoutHdpa(BigDecimalUtils.defaultValue(calculationContext.getFinalAmountWithoutHdpa()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            calculationContext.setFinalAmountWithHdpa(BigDecimalUtils.defaultValue(calculationContext.getFinalAmountWithHdpa()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            bundledData.setFullOutlierRate(BigDecimalUtils.defaultValue(bundledData.getFullOutlierRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
        }
    }
}

