/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import com.codahale.metrics.health.HealthCheckRegistry;
import io.dropwizard.health.HealthStateAggregator;
import io.dropwizard.health.HealthStateListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthEnvironment.class);
    @Nonnull
    private final HealthCheckRegistry healthCheckRegistry;
    @Nonnull
    private final Collection<HealthStateListener> healthStateListeners;
    @Nullable
    private HealthStateAggregator healthStateAggregator;

    public HealthEnvironment(HealthCheckRegistry healthCheckRegistry) {
        this.healthCheckRegistry = Objects.requireNonNull(healthCheckRegistry);
        this.healthStateListeners = new ArrayList<HealthStateListener>();
    }

    public void addHealthStateListener(HealthStateListener listener) {
        this.healthStateListeners.add(listener);
    }

    @Nonnull
    public HealthCheckRegistry healthChecks() {
        return this.healthCheckRegistry;
    }

    @Nonnull
    public Collection<HealthStateListener> healthStateListeners() {
        return this.healthStateListeners;
    }

    @Nonnull
    public HealthStateAggregator healthStateAggregator() {
        if (this.healthStateAggregator == null) {
            String message = "Cannot access the HealthStateAggregator before HealthFactory setup has occurred";
            LOGGER.error("Cannot access the HealthStateAggregator before HealthFactory setup has occurred");
            throw new IllegalStateException("Cannot access the HealthStateAggregator before HealthFactory setup has occurred");
        }
        return this.healthStateAggregator;
    }

    void setHealthStateAggregator(@Nonnull HealthStateAggregator healthStateAggregator) {
        this.healthStateAggregator = Objects.requireNonNull(healthStateAggregator);
    }
}

