/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import io.dropwizard.logging.ResilientOutputStreamBase;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.annotation.Nullable;
import javax.net.SocketFactory;

public class ResilientSocketOutputStream
extends ResilientOutputStreamBase {
    private final String host;
    private final int port;
    private final int connectionTimeoutMs;
    private final int sendBufferSize;
    private final SocketFactory socketFactory;
    @Nullable
    private Socket socket;

    public ResilientSocketOutputStream(String host, int port, int connectionTimeoutMs, int sendBufferSize, SocketFactory socketFactory) {
        this.host = host;
        this.port = port;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.sendBufferSize = sendBufferSize;
        this.socketFactory = socketFactory;
        try {
            this.os = this.openNewOutputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create a TCP connection to " + host + ":" + port, e);
        }
        this.presumedClean = true;
    }

    @Override
    String getDescription() {
        return "tcp [" + this.host + ":" + this.port + "]";
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closeSocket();
    }

    private void closeSocket() throws IOException {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    OutputStream openNewOutputStream() throws IOException {
        this.closeSocket();
        this.socket = this.socketFactory.createSocket();
        this.socket.setKeepAlive(true);
        this.socket.connect(new InetSocketAddress(InetAddress.getByName(this.host), this.port), this.connectionTimeoutMs);
        return new BufferedOutputStream(this.socket.getOutputStream(), this.sendBufferSize);
    }
}

