/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.websockets.Broadcaster;
import org.glassfish.grizzly.websockets.ClosingFrame;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.DummyBroadcaster;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.glassfish.grizzly.websockets.frametypes.PingFrameType;
import org.glassfish.grizzly.websockets.frametypes.PongFrameType;

public class SimpleWebSocket
implements WebSocket {
    private static final Logger LOGGER = Grizzly.logger(DefaultWebSocket.class);
    protected final Queue<WebSocketListener> listeners = new ConcurrentLinkedQueue<WebSocketListener>();
    protected final ProtocolHandler protocolHandler;
    protected Broadcaster broadcaster = new DummyBroadcaster();
    protected final EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    protected final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    public SimpleWebSocket(ProtocolHandler protocolHandler, WebSocketListener ... listeners) {
        this.protocolHandler = protocolHandler;
        for (WebSocketListener listener : listeners) {
            this.add(listener);
        }
        protocolHandler.setWebSocket(this);
    }

    public Collection<WebSocketListener> getListeners() {
        return this.listeners;
    }

    @Override
    public final boolean add(WebSocketListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public final boolean remove(WebSocketListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    public void setClosed() {
        this.state.set(State.CLOSED);
    }

    @Override
    public void onClose(DataFrame frame) {
        WebSocketListener listener;
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            ClosingFrame closing = (ClosingFrame)frame;
            this.protocolHandler.close(closing.getCode(), closing.getTextPayload());
        } else {
            this.state.set(State.CLOSED);
            this.protocolHandler.doClose();
        }
        while ((listener = this.listeners.poll()) != null) {
            listener.onClose(this, frame);
        }
    }

    @Override
    public void onConnect() {
        this.state.set(State.CONNECTED);
        for (WebSocketListener listener : this.listeners) {
            listener.onConnect(this);
        }
    }

    @Override
    public void onFragment(boolean last, byte[] fragment) {
        for (WebSocketListener listener : this.listeners) {
            listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onFragment(boolean last, String fragment) {
        for (WebSocketListener listener : this.listeners) {
            listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onMessage(byte[] data) {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, data);
        }
    }

    @Override
    public void onMessage(String text) {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, text);
        }
    }

    @Override
    public void onPing(DataFrame frame) {
        this.send(new DataFrame((FrameType)new PongFrameType(), frame.getBytes()));
        for (WebSocketListener listener : this.listeners) {
            listener.onPing(this, frame.getBytes());
        }
    }

    @Override
    public void onPong(DataFrame frame) {
        for (WebSocketListener listener : this.listeners) {
            listener.onPong(this, frame.getBytes());
        }
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int code) {
        this.close(code, null);
    }

    @Override
    public void close(int code, String reason) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(code, reason);
        }
    }

    @Override
    public GrizzlyFuture<DataFrame> send(byte[] data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public GrizzlyFuture<DataFrame> send(String data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public void broadcast(Iterable<? extends WebSocket> recipients, String data) {
        if (this.state.get() != State.CONNECTED) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.broadcaster.broadcast(recipients, data);
    }

    @Override
    public void broadcast(Iterable<? extends WebSocket> recipients, byte[] data) {
        if (this.state.get() != State.CONNECTED) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.broadcaster.broadcast(recipients, data);
    }

    @Override
    public void broadcastFragment(Iterable<? extends WebSocket> recipients, String data, boolean last) {
        if (this.state.get() != State.CONNECTED) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.broadcaster.broadcastFragment(recipients, data, last);
    }

    @Override
    public void broadcastFragment(Iterable<? extends WebSocket> recipients, byte[] data, boolean last) {
        if (this.state.get() != State.CONNECTED) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.broadcaster.broadcastFragment(recipients, data, last);
    }

    @Override
    public GrizzlyFuture<DataFrame> sendPing(byte[] data) {
        return this.send(new DataFrame((FrameType)new PingFrameType(), data));
    }

    @Override
    public GrizzlyFuture<DataFrame> sendPong(byte[] data) {
        return this.send(new DataFrame((FrameType)new PongFrameType(), data));
    }

    private GrizzlyFuture<DataFrame> send(DataFrame frame) {
        if (this.isConnected()) {
            return this.protocolHandler.send(frame);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public GrizzlyFuture<DataFrame> stream(boolean last, String fragment) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, fragment);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public GrizzlyFuture<DataFrame> stream(boolean last, byte[] bytes, int off, int len) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, bytes, off, len);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    protected byte[] toRawData(String text) {
        return this.toRawData(text, true);
    }

    protected byte[] toRawData(byte[] binary) {
        return this.toRawData(binary, true);
    }

    protected byte[] toRawData(String fragment, boolean last) {
        DataFrame dataFrame = this.protocolHandler.toDataFrame(fragment, last);
        return this.protocolHandler.frame(dataFrame);
    }

    protected byte[] toRawData(byte[] binary, boolean last) {
        DataFrame dataFrame = this.protocolHandler.toDataFrame(binary, last);
        return this.protocolHandler.frame(dataFrame);
    }

    protected void sendRaw(byte[] rawData) {
        Connection connection = this.protocolHandler.getConnection();
        MemoryManager mm4 = connection.getTransport().getMemoryManager();
        Buffer buffer = Buffers.wrap(mm4, rawData);
        buffer.allowBufferDispose(false);
        connection.write(buffer);
    }

    protected Broadcaster getBroadcaster() {
        return this.broadcaster;
    }

    protected void setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    protected static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

