/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly.connector;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.RequestBuilder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.Initializable;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.grizzly.connector.GrizzlyConnector;
import org.glassfish.jersey.grizzly.connector.LocalizationMessages;
import org.glassfish.jersey.internal.util.Property;

public class GrizzlyConnectorProvider
implements ConnectorProvider {
    @Property
    static final String REQUEST_CUSTOMIZER = "jersey.config.grizzly.client.request.customizer";
    private final AsyncClientCustomizer asyncClientCustomizer;

    public GrizzlyConnectorProvider() {
        this.asyncClientCustomizer = null;
    }

    public GrizzlyConnectorProvider(AsyncClientCustomizer asyncClientCustomizer) {
        this.asyncClientCustomizer = asyncClientCustomizer;
    }

    @Override
    public Connector getConnector(Client client, Configuration config) {
        return new GrizzlyConnector(client, config, this.asyncClientCustomizer);
    }

    public static AsyncHttpClient getHttpClient(Configurable<?> component) {
        if (!(component instanceof Initializable)) {
            throw new IllegalArgumentException(LocalizationMessages.INVALID_CONFIGURABLE_COMPONENT_TYPE(component.getClass().getName()));
        }
        Initializable initializable = (Initializable)((Object)component);
        Connector connector = initializable.getConfiguration().getConnector();
        if (connector == null) {
            initializable.preInitialize();
            connector = initializable.getConfiguration().getConnector();
        }
        if (connector instanceof GrizzlyConnector) {
            return ((GrizzlyConnector)connector).getGrizzlyClient();
        }
        throw new IllegalArgumentException(LocalizationMessages.EXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }

    public static Invocation.Builder register(Invocation.Builder builder, RequestCustomizer customizer) {
        return builder.property(REQUEST_CUSTOMIZER, customizer);
    }

    public static ClientConfig register(ClientConfig config, RequestCustomizer customizer) {
        return config.property(REQUEST_CUSTOMIZER, customizer);
    }

    public static interface RequestCustomizer {
        public RequestBuilder customize(ClientRequest var1, RequestBuilder var2);
    }

    public static interface AsyncClientCustomizer {
        public AsyncHttpClientConfig.Builder customize(Client var1, Configuration var2, AsyncHttpClientConfig.Builder var3);
    }
}

