/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv.money;

import java.math.BigDecimal;
import javax.money.MonetaryAmount;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Max;

public class MaxValidatorForMonetaryAmount
implements ConstraintValidator<Max, MonetaryAmount> {
    private BigDecimal maxValue;

    @Override
    public void initialize(Max maxValue) {
        this.maxValue = BigDecimal.valueOf(maxValue.value());
    }

    @Override
    public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return ((BigDecimal)value.getNumber().numberValueExact(BigDecimal.class)).compareTo(this.maxValue) != 1;
    }
}

