/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

final class DisplayNameUtils {
    private static final Logger logger = LoggerFactory.getLogger(DisplayNameUtils.class);
    private static final DisplayNameGenerator standardGenerator = DisplayNameGenerator.getDisplayNameGenerator(DisplayNameGenerator.Standard.class);
    private static final DisplayNameGenerator simpleGenerator = DisplayNameGenerator.getDisplayNameGenerator(DisplayNameGenerator.Simple.class);
    private static final DisplayNameGenerator replaceUnderscoresGenerator = DisplayNameGenerator.getDisplayNameGenerator(DisplayNameGenerator.ReplaceUnderscores.class);
    private static final DisplayNameGenerator indicativeSentencesGenerator = DisplayNameGenerator.getDisplayNameGenerator(DisplayNameGenerator.IndicativeSentences.class);

    DisplayNameUtils() {
    }

    static String determineDisplayName(AnnotatedElement element, Supplier<String> displayNameSupplier) {
        Preconditions.notNull(element, "Annotated element must not be null");
        Optional<DisplayName> displayNameAnnotation = AnnotationUtils.findAnnotation(element, DisplayName.class);
        if (displayNameAnnotation.isPresent()) {
            String displayName = displayNameAnnotation.get().value().trim();
            if (StringUtils.isBlank(displayName)) {
                logger.warn(() -> String.format("Configuration error: @DisplayName on [%s] must be declared with a non-empty value.", element));
            } else {
                return displayName;
            }
        }
        return displayNameSupplier.get();
    }

    static String determineDisplayNameForMethod(Class<?> testClass, Method testMethod, JupiterConfiguration configuration) {
        return DisplayNameUtils.determineDisplayName(testMethod, DisplayNameUtils.createDisplayNameSupplierForMethod(testClass, testMethod, configuration));
    }

    static Supplier<String> createDisplayNameSupplierForClass(Class<?> testClass, JupiterConfiguration configuration) {
        return DisplayNameUtils.createDisplayNameSupplier(testClass, configuration, generator -> generator.generateDisplayNameForClass(testClass));
    }

    static Supplier<String> createDisplayNameSupplierForNestedClass(Class<?> testClass, JupiterConfiguration configuration) {
        return DisplayNameUtils.createDisplayNameSupplier(testClass, configuration, generator -> generator.generateDisplayNameForNestedClass(testClass));
    }

    private static Supplier<String> createDisplayNameSupplierForMethod(Class<?> testClass, Method testMethod, JupiterConfiguration configuration) {
        return DisplayNameUtils.createDisplayNameSupplier(testClass, configuration, generator -> generator.generateDisplayNameForMethod(testClass, testMethod));
    }

    private static Supplier<String> createDisplayNameSupplier(Class<?> testClass, JupiterConfiguration configuration, Function<DisplayNameGenerator, String> generatorFunction) {
        return () -> DisplayNameUtils.findDisplayNameGenerator(testClass).map(generatorFunction).orElseGet(() -> (String)generatorFunction.apply(configuration.getDefaultDisplayNameGenerator()));
    }

    private static Optional<DisplayNameGenerator> findDisplayNameGenerator(Class<?> testClass) {
        Preconditions.notNull(testClass, "Test class must not be null");
        return AnnotationUtils.findAnnotation(testClass, DisplayNameGeneration.class, true).map(DisplayNameGeneration::value).map(displayNameGeneratorClass -> {
            if (displayNameGeneratorClass == DisplayNameGenerator.Standard.class) {
                return standardGenerator;
            }
            if (displayNameGeneratorClass == DisplayNameGenerator.Simple.class) {
                return simpleGenerator;
            }
            if (displayNameGeneratorClass == DisplayNameGenerator.ReplaceUnderscores.class) {
                return replaceUnderscoresGenerator;
            }
            if (displayNameGeneratorClass == DisplayNameGenerator.IndicativeSentences.class) {
                return indicativeSentencesGenerator;
            }
            return (DisplayNameGenerator)ReflectionUtils.newInstance(displayNameGeneratorClass, new Object[0]);
        });
    }
}

