/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.NullEnum;
import org.junit.platform.commons.util.Preconditions;

class EnumArgumentsProvider
extends AnnotationBasedArgumentsProvider<EnumSource> {
    EnumArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ExtensionContext context, EnumSource enumSource) {
        Set<Enum> constants = this.getEnumConstants(context, enumSource);
        EnumSource.Mode mode = enumSource.mode();
        String[] declaredConstantNames = enumSource.names();
        if (declaredConstantNames.length > 0) {
            Set<String> uniqueNames = Arrays.stream(declaredConstantNames).collect(Collectors.toSet());
            Preconditions.condition(uniqueNames.size() == declaredConstantNames.length, () -> "Duplicate enum constant name(s) found in " + enumSource);
            mode.validate(enumSource, constants, uniqueNames);
            constants.removeIf(constant -> !mode.select((Enum<?>)constant, uniqueNames));
        }
        return constants.stream().map(xva$0 -> Arguments.of(xva$0));
    }

    private <E extends Enum<E>> Set<? extends E> getEnumConstants(ExtensionContext context, EnumSource enumSource) {
        Class<E> enumClass = this.determineEnumClass(context, enumSource);
        return EnumSet.allOf(enumClass);
    }

    private <E extends Enum<E>> Class<E> determineEnumClass(ExtensionContext context, EnumSource enumSource) {
        Class<Enum> enumClass = enumSource.value();
        if (enumClass.equals(NullEnum.class)) {
            Method method = context.getRequiredTestMethod();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Preconditions.condition(parameterTypes.length > 0, () -> "Test method must declare at least one parameter: " + method.toGenericString());
            Preconditions.condition(Enum.class.isAssignableFrom(parameterTypes[0]), () -> "First parameter must reference an Enum type (alternatively, use the annotation's 'value' attribute to specify the type explicitly): " + method.toGenericString());
            enumClass = parameterTypes[0];
        }
        return enumClass;
    }
}

