/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.zalando.problem.StatusType;
import org.zalando.problem.jackson.UnknownStatus;

final class StatusTypeDeserializer
extends JsonDeserializer<StatusType> {
    private final Map<Integer, StatusType> index;

    StatusTypeDeserializer(Map<Integer, StatusType> index) {
        this.index = index;
    }

    @Override
    public StatusType deserialize(JsonParser json, DeserializationContext context) throws IOException {
        int statusCode = json.getIntValue();
        @Nullable StatusType status = this.index.get(statusCode);
        return status == null ? new UnknownStatus(statusCode) : status;
    }
}

