// Generated by delombok at Thu May 22 14:06:18 UTC 2025
package gov.cms.fiss.pricers.esrd.api.v2;

import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.Size;

@Schema(description = "The comorbidity reference information for the claim.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "COMORBIDITIES-PORTION", value = "<structure>")})})
public class ComorbidityData {
  @ArraySchema(arraySchema = @Schema(description = "The comorbidity data; used when no return code is provided. It is expected " + "that the values \'MA\' and \'MC\' will only be used for the first two " + "positions, and the values \'MD\' and \'ME\' will only be used for the last " + "two positions.", allowableValues = {"MA", "MC", "MD", "ME"}, example = "[ \"MA\", \"MC\" ]"), uniqueItems = true, extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "COMORBID-DATA", value = "OCCURS 6 TIMES\n INDEXED BY COMORBID-INDEX\n PIC X(02)", parseValue = true)})})
  @Size(max = 6, min = 1)
  private List<@ValidComorbidityCode String> comorbidityCodes;
  @Schema(description = "Common working file return code for the specified comorbidities.", allowableValues = {"10", "20", "30", "40", "50", "60", "70"}, example = "40", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "COMORBID-CWF-RETURN-CODE", value = "PIC X(02)")})})
  @ValidCommonWorkingFileReturnCode
  private String cwfReturnCode;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@ValidComorbidityCode String> getComorbidityCodes() {
    return this.comorbidityCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCwfReturnCode() {
    return this.cwfReturnCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setComorbidityCodes(final List<@ValidComorbidityCode String> comorbidityCodes) {
    this.comorbidityCodes = comorbidityCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCwfReturnCode(final String cwfReturnCode) {
    this.cwfReturnCode = cwfReturnCode;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ComorbidityData)) return false;
    final ComorbidityData other = (ComorbidityData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$comorbidityCodes = this.getComorbidityCodes();
    final java.lang.Object other$comorbidityCodes = other.getComorbidityCodes();
    if (this$comorbidityCodes == null ? other$comorbidityCodes != null : !this$comorbidityCodes.equals(other$comorbidityCodes)) return false;
    final java.lang.Object this$cwfReturnCode = this.getCwfReturnCode();
    final java.lang.Object other$cwfReturnCode = other.getCwfReturnCode();
    if (this$cwfReturnCode == null ? other$cwfReturnCode != null : !this$cwfReturnCode.equals(other$cwfReturnCode)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ComorbidityData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $comorbidityCodes = this.getComorbidityCodes();
    result = result * PRIME + ($comorbidityCodes == null ? 43 : $comorbidityCodes.hashCode());
    final java.lang.Object $cwfReturnCode = this.getCwfReturnCode();
    result = result * PRIME + ($cwfReturnCode == null ? 43 : $cwfReturnCode.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "ComorbidityData(comorbidityCodes=" + this.getComorbidityCodes() + ", cwfReturnCode=" + this.getCwfReturnCode() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ComorbidityData() {
  }
}
