/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.blackbird.ser.OptimizedBeanPropertyWriter;
import java.util.function.ToLongFunction;

final class LongPropertyWriter
extends OptimizedBeanPropertyWriter<LongPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final long _suppressableLong;
    private final boolean _suppressableSet;
    private final ToLongFunction<Object> _acc;

    public LongPropertyWriter(BeanPropertyWriter src, ToLongFunction<Object> acc, JsonSerializer<Object> ser) {
        super(src, ser);
        this._acc = acc;
        if (this._suppressableValue instanceof Long) {
            this._suppressableLong = (Long)this._suppressableValue;
            this._suppressableSet = true;
        } else {
            this._suppressableLong = 0L;
            this._suppressableSet = false;
        }
    }

    protected LongPropertyWriter(LongPropertyWriter base, PropertyName name) {
        super(base, name);
        this._suppressableSet = base._suppressableSet;
        this._suppressableLong = base._suppressableLong;
        this._acc = base._acc;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new LongPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new LongPropertyWriter(this, this._acc, ser);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        long value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.applyAsLong(bean);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, false);
            return;
        }
        if (!this._suppressableSet || this._suppressableLong != value) {
            gen.writeFieldName(this._fastName);
            gen.writeNumber(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        long value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.applyAsLong(bean);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, false);
            return;
        }
        if (!this._suppressableSet || this._suppressableLong != value) {
            gen.writeNumber(value);
        } else {
            this.serializeAsPlaceholder(bean, gen, prov);
        }
    }
}

