/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="Defines a request from claim pricing.")
public class ClaimPricingResponse<T extends PaymentData> {
    @NotNull
    @Pattern(regexp="\\d{4}.([\\d]|[1-9][\\d]?)", message="must be 4 digits followed by a period and one to two digits; if one digit, it cannot be zero and if two digits it cannot start with zero")
    @Schema(description="The version of the pricing calculation used to generate the payment data.", example="2022.1")
    private @NotNull @Pattern(regexp="\\d{4}.([\\d]|[1-9][\\d]?)", message="must be 4 digits followed by a period and one to two digits; if one digit, it cannot be zero and if two digits it cannot start with zero") String calculationVersion;
    @NotNull
    @Schema(description="The payment information generated by claim pricing.")
    @Valid
    private T paymentData;
    @NotNull
    @Schema(description="The pricing response classification metadata. This data can be used to determine if the pricing attempt succeeded, and under what conditions.")
    @Valid
    private ReturnCodeData returnCodeData = ReturnCodeData.EMPTY_RETURN_CODE;

    @Generated
    public String getCalculationVersion() {
        return this.calculationVersion;
    }

    @Generated
    public T getPaymentData() {
        return this.paymentData;
    }

    @Generated
    public ReturnCodeData getReturnCodeData() {
        return this.returnCodeData;
    }

    @Generated
    public void setCalculationVersion(String calculationVersion) {
        this.calculationVersion = calculationVersion;
    }

    @Generated
    public void setPaymentData(T paymentData) {
        this.paymentData = paymentData;
    }

    @Generated
    public void setReturnCodeData(ReturnCodeData returnCodeData) {
        this.returnCodeData = returnCodeData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimPricingResponse)) {
            return false;
        }
        ClaimPricingResponse other = (ClaimPricingResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$calculationVersion = this.getCalculationVersion();
        String other$calculationVersion = other.getCalculationVersion();
        if (this$calculationVersion == null ? other$calculationVersion != null : !this$calculationVersion.equals(other$calculationVersion)) {
            return false;
        }
        T this$paymentData = this.getPaymentData();
        T other$paymentData = other.getPaymentData();
        if (this$paymentData == null ? other$paymentData != null : !this$paymentData.equals(other$paymentData)) {
            return false;
        }
        ReturnCodeData this$returnCodeData = this.getReturnCodeData();
        ReturnCodeData other$returnCodeData = other.getReturnCodeData();
        return !(this$returnCodeData == null ? other$returnCodeData != null : !((Object)this$returnCodeData).equals(other$returnCodeData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimPricingResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $calculationVersion = this.getCalculationVersion();
        result = result * 59 + ($calculationVersion == null ? 43 : $calculationVersion.hashCode());
        T $paymentData = this.getPaymentData();
        result = result * 59 + ($paymentData == null ? 43 : $paymentData.hashCode());
        ReturnCodeData $returnCodeData = this.getReturnCodeData();
        result = result * 59 + ($returnCodeData == null ? 43 : ((Object)$returnCodeData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClaimPricingResponse(calculationVersion=" + this.getCalculationVersion() + ", paymentData=" + this.getPaymentData() + ", returnCodeData=" + this.getReturnCodeData() + ")";
    }

    @Generated
    public ClaimPricingResponse() {
    }
}

