/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.resources;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.application.resources.HealthCheckResult;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import lombok.Generated;

@Schema(description="Aggregate health mappings.", deprecated=true)
public class HealthCheckResults {
    private Map<String, HealthCheckResult> healthResults;

    public static HealthCheckResults fromHealthChecks(SortedMap<String, HealthCheck.Result> results) {
        Map<String, HealthCheckResult> mappedResults = results.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> HealthCheckResult.fromResult((HealthCheck.Result)e.getValue())));
        return new HealthCheckResults(mappedResults);
    }

    @JsonIgnore
    public boolean isHealthy() {
        return this.healthResults.values().stream().allMatch(HealthCheckResult::isHealthy);
    }

    @Generated
    public HealthCheckResults(Map<String, HealthCheckResult> healthResults) {
        this.healthResults = healthResults;
    }

    @Generated
    public Map<String, HealthCheckResult> getHealthResults() {
        return this.healthResults;
    }

    @Generated
    public void setHealthResults(Map<String, HealthCheckResult> healthResults) {
        this.healthResults = healthResults;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HealthCheckResults)) {
            return false;
        }
        HealthCheckResults other = (HealthCheckResults)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, HealthCheckResult> this$healthResults = this.getHealthResults();
        Map<String, HealthCheckResult> other$healthResults = other.getHealthResults();
        return !(this$healthResults == null ? other$healthResults != null : !((Object)this$healthResults).equals(other$healthResults));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HealthCheckResults;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, HealthCheckResult> $healthResults = this.getHealthResults();
        result = result * 59 + ($healthResults == null ? 43 : ((Object)$healthResults).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HealthCheckResults(healthResults=" + this.getHealthResults() + ")";
    }

    @Generated
    public HealthCheckResults() {
    }
}

