/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.esrd.EsrdPricerConfiguration;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerDispatch;
import gov.cms.fiss.pricers.esrd.resources.EsrdClaimPricingResource;
import gov.cms.fiss.pricers.esrd.resources.EsrdExtractionUtil;
import io.dropwizard.core.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EsrdPricerApplication
extends OpenApiPricerApplication<EsrdPricerConfiguration> {
    public static void main(String[] args) throws Exception {
        new EsrdPricerApplication().run(args);
    }

    @Override
    protected void configureApplication(EsrdPricerConfiguration pricerConfiguration, Environment environment) {
        EsrdClaimPricingResource v2Resource = new EsrdClaimPricingResource(new EsrdPricerDispatch(pricerConfiguration));
        environment.jersey().register(v2Resource);
        environment.jersey().register(new CbsaWageIndexResource(pricerConfiguration, EsrdExtractionUtil.CBSA_EXTRACTOR));
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("ESRD Pricer").version("v1")));
        return customizers;
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.of(2020, StringUtils.join((Object[])new String[]{"2020.0", "2020.2"}, ','), 2021, "2021.2", 2022, "2022.4", 2023, "2023.2", 2024, "2024.0", 2025, "2025.2", 2026, "2026.0");
    }

    @Override
    public String getName() {
        return "esrd-pricer";
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(EsrdClaimPricingResource.class.getPackage());
    }
}

