/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="The additional payment information for the claim.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OTHER-DATA", value="<structure>")})})
public class AdditionalPaymentData {
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The age adjustment factor used.", example="1.068", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-AGE-FACTOR", value="PIC 9(01)V9(03)"), @ExtensionProperty(name="PPS-2011-AGE-FACTOR", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal ageAdjustmentFactor;
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(description="The body-mass index (BMI) adjustment factor used.", example="1.0683", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BMI-FACTOR", value="PIC 9(01)V9(04)"), @ExtensionProperty(name="PPS-2011-BMI-FACTOR", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal bodyMassIndexFactor;
    @BigDecimalScale(scale=4)
    @Schema(description="The body-surface area (BSA) adjustment factor used.", example="4.3825", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BSA-FACTOR", value="PIC 9(01)V9(04)"), @ExtensionProperty(name="PPS-2011-BSA-FACTOR", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal bodySurfaceAreaFactor;
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(description="The budget neutrality rate amount.", example="0.9116", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BDGT-NEUT-RATE", value="PIC 9(01)V9(04)"), @ExtensionProperty(name="PPS-2011-BDGT-NEUT-RATE", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal budgetNeutralityRate;
    @BigDecimalScale(scale=5)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99999")
    @Digits(integer=1, fraction=5)
    @Schema(description="The national labor percent.", example="0.46205", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-LABOR-PCT", value="PIC 9(01)V9(05)"), @ExtensionProperty(name="PPS-2011-NAT-LABOR-PCT", value="PIC 9(01)V9(05)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99999") @Digits(integer=1, fraction=5) @FixedValue BigDecimal nationalLaborPercent;
    @BigDecimalScale(scale=5)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99999")
    @Digits(integer=1, fraction=5)
    @Schema(description="The national non-labor percent.", example="0.53795", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-NONLABOR-PCT", value="PIC 9(01)V9(05)"), @ExtensionProperty(name="PPS-2011-NAT-NONLABOR-PCT", value="PIC 9(01)V9(05)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99999") @Digits(integer=1, fraction=5) @FixedValue BigDecimal nationalNonLaborPercent;
    @BigDecimalScale
    @Schema(description="The wage-adjusted payment rate.", example="324.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-WAGE-ADJ-RATE", value="PIC 9(04)V9(02)"), @ExtensionProperty(name="PPS-2011-WAGE-ADJ-RATE", value="PIC 9(04)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal wageAdjustmentRate;

    @Generated
    public BigDecimal getAgeAdjustmentFactor() {
        return this.ageAdjustmentFactor;
    }

    @Generated
    public BigDecimal getBodyMassIndexFactor() {
        return this.bodyMassIndexFactor;
    }

    @Generated
    public BigDecimal getBodySurfaceAreaFactor() {
        return this.bodySurfaceAreaFactor;
    }

    @Generated
    public BigDecimal getBudgetNeutralityRate() {
        return this.budgetNeutralityRate;
    }

    @Generated
    public BigDecimal getNationalLaborPercent() {
        return this.nationalLaborPercent;
    }

    @Generated
    public BigDecimal getNationalNonLaborPercent() {
        return this.nationalNonLaborPercent;
    }

    @Generated
    public BigDecimal getWageAdjustmentRate() {
        return this.wageAdjustmentRate;
    }

    @Generated
    public void setAgeAdjustmentFactor(BigDecimal ageAdjustmentFactor) {
        this.ageAdjustmentFactor = ageAdjustmentFactor;
    }

    @Generated
    public void setBodyMassIndexFactor(BigDecimal bodyMassIndexFactor) {
        this.bodyMassIndexFactor = bodyMassIndexFactor;
    }

    @Generated
    public void setBodySurfaceAreaFactor(BigDecimal bodySurfaceAreaFactor) {
        this.bodySurfaceAreaFactor = bodySurfaceAreaFactor;
    }

    @Generated
    public void setBudgetNeutralityRate(BigDecimal budgetNeutralityRate) {
        this.budgetNeutralityRate = budgetNeutralityRate;
    }

    @Generated
    public void setNationalLaborPercent(BigDecimal nationalLaborPercent) {
        this.nationalLaborPercent = nationalLaborPercent;
    }

    @Generated
    public void setNationalNonLaborPercent(BigDecimal nationalNonLaborPercent) {
        this.nationalNonLaborPercent = nationalNonLaborPercent;
    }

    @Generated
    public void setWageAdjustmentRate(BigDecimal wageAdjustmentRate) {
        this.wageAdjustmentRate = wageAdjustmentRate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdditionalPaymentData)) {
            return false;
        }
        AdditionalPaymentData other = (AdditionalPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$ageAdjustmentFactor = this.getAgeAdjustmentFactor();
        BigDecimal other$ageAdjustmentFactor = other.getAgeAdjustmentFactor();
        if (this$ageAdjustmentFactor == null ? other$ageAdjustmentFactor != null : !((Object)this$ageAdjustmentFactor).equals(other$ageAdjustmentFactor)) {
            return false;
        }
        BigDecimal this$bodyMassIndexFactor = this.getBodyMassIndexFactor();
        BigDecimal other$bodyMassIndexFactor = other.getBodyMassIndexFactor();
        if (this$bodyMassIndexFactor == null ? other$bodyMassIndexFactor != null : !((Object)this$bodyMassIndexFactor).equals(other$bodyMassIndexFactor)) {
            return false;
        }
        BigDecimal this$bodySurfaceAreaFactor = this.getBodySurfaceAreaFactor();
        BigDecimal other$bodySurfaceAreaFactor = other.getBodySurfaceAreaFactor();
        if (this$bodySurfaceAreaFactor == null ? other$bodySurfaceAreaFactor != null : !((Object)this$bodySurfaceAreaFactor).equals(other$bodySurfaceAreaFactor)) {
            return false;
        }
        BigDecimal this$budgetNeutralityRate = this.getBudgetNeutralityRate();
        BigDecimal other$budgetNeutralityRate = other.getBudgetNeutralityRate();
        if (this$budgetNeutralityRate == null ? other$budgetNeutralityRate != null : !((Object)this$budgetNeutralityRate).equals(other$budgetNeutralityRate)) {
            return false;
        }
        BigDecimal this$nationalLaborPercent = this.getNationalLaborPercent();
        BigDecimal other$nationalLaborPercent = other.getNationalLaborPercent();
        if (this$nationalLaborPercent == null ? other$nationalLaborPercent != null : !((Object)this$nationalLaborPercent).equals(other$nationalLaborPercent)) {
            return false;
        }
        BigDecimal this$nationalNonLaborPercent = this.getNationalNonLaborPercent();
        BigDecimal other$nationalNonLaborPercent = other.getNationalNonLaborPercent();
        if (this$nationalNonLaborPercent == null ? other$nationalNonLaborPercent != null : !((Object)this$nationalNonLaborPercent).equals(other$nationalNonLaborPercent)) {
            return false;
        }
        BigDecimal this$wageAdjustmentRate = this.getWageAdjustmentRate();
        BigDecimal other$wageAdjustmentRate = other.getWageAdjustmentRate();
        return !(this$wageAdjustmentRate == null ? other$wageAdjustmentRate != null : !((Object)this$wageAdjustmentRate).equals(other$wageAdjustmentRate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdditionalPaymentData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $ageAdjustmentFactor = this.getAgeAdjustmentFactor();
        result = result * 59 + ($ageAdjustmentFactor == null ? 43 : ((Object)$ageAdjustmentFactor).hashCode());
        BigDecimal $bodyMassIndexFactor = this.getBodyMassIndexFactor();
        result = result * 59 + ($bodyMassIndexFactor == null ? 43 : ((Object)$bodyMassIndexFactor).hashCode());
        BigDecimal $bodySurfaceAreaFactor = this.getBodySurfaceAreaFactor();
        result = result * 59 + ($bodySurfaceAreaFactor == null ? 43 : ((Object)$bodySurfaceAreaFactor).hashCode());
        BigDecimal $budgetNeutralityRate = this.getBudgetNeutralityRate();
        result = result * 59 + ($budgetNeutralityRate == null ? 43 : ((Object)$budgetNeutralityRate).hashCode());
        BigDecimal $nationalLaborPercent = this.getNationalLaborPercent();
        result = result * 59 + ($nationalLaborPercent == null ? 43 : ((Object)$nationalLaborPercent).hashCode());
        BigDecimal $nationalNonLaborPercent = this.getNationalNonLaborPercent();
        result = result * 59 + ($nationalNonLaborPercent == null ? 43 : ((Object)$nationalNonLaborPercent).hashCode());
        BigDecimal $wageAdjustmentRate = this.getWageAdjustmentRate();
        result = result * 59 + ($wageAdjustmentRate == null ? 43 : ((Object)$wageAdjustmentRate).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdditionalPaymentData(ageAdjustmentFactor=" + this.getAgeAdjustmentFactor() + ", bodyMassIndexFactor=" + this.getBodyMassIndexFactor() + ", bodySurfaceAreaFactor=" + this.getBodySurfaceAreaFactor() + ", budgetNeutralityRate=" + this.getBudgetNeutralityRate() + ", nationalLaborPercent=" + this.getNationalLaborPercent() + ", nationalNonLaborPercent=" + this.getNationalNonLaborPercent() + ", wageAdjustmentRate=" + this.getWageAdjustmentRate() + ")";
    }

    @Generated
    public AdditionalPaymentData() {
    }
}

