/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="The bundled billing information for display; separate from the claim pricing result.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-DATA-TEST", value="<structure>")})})
public class BundledBillingData {
    @BigDecimalScale(scale=4)
    @Schema(description="The bundled body-mass index (BMI) factor.", example="750.2412", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BUN-BMI", value="PIC 9(03)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal bundledBodyMassIndexFactor;
    @BigDecimalScale(scale=4)
    @Schema(description="The bundled body-surface area (BSA) factor.", example="12.4534", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BUN-BSA", value="PIC 9(03)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal bundledBodySurfaceAreaFactor;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The bundled comorbidity multiplier.", example="7.439", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BUN-COMORBID-MULTIPLIER", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal bundledComorbidityMultiplier;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The bundled low-volume facility adjustment percent.", example="6.882", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BUN-LOW-VOL-MULTIPLIER", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal bundledLowVolumeFacilityAdjustmentPercent;
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(description="The bundled onset factor.", example="3.4534", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BUN-ONSET-FACTOR", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal bundledOnsetFactor;

    @Generated
    public BigDecimal getBundledBodyMassIndexFactor() {
        return this.bundledBodyMassIndexFactor;
    }

    @Generated
    public BigDecimal getBundledBodySurfaceAreaFactor() {
        return this.bundledBodySurfaceAreaFactor;
    }

    @Generated
    public BigDecimal getBundledComorbidityMultiplier() {
        return this.bundledComorbidityMultiplier;
    }

    @Generated
    public BigDecimal getBundledLowVolumeFacilityAdjustmentPercent() {
        return this.bundledLowVolumeFacilityAdjustmentPercent;
    }

    @Generated
    public BigDecimal getBundledOnsetFactor() {
        return this.bundledOnsetFactor;
    }

    @Generated
    public void setBundledBodyMassIndexFactor(BigDecimal bundledBodyMassIndexFactor) {
        this.bundledBodyMassIndexFactor = bundledBodyMassIndexFactor;
    }

    @Generated
    public void setBundledBodySurfaceAreaFactor(BigDecimal bundledBodySurfaceAreaFactor) {
        this.bundledBodySurfaceAreaFactor = bundledBodySurfaceAreaFactor;
    }

    @Generated
    public void setBundledComorbidityMultiplier(BigDecimal bundledComorbidityMultiplier) {
        this.bundledComorbidityMultiplier = bundledComorbidityMultiplier;
    }

    @Generated
    public void setBundledLowVolumeFacilityAdjustmentPercent(BigDecimal bundledLowVolumeFacilityAdjustmentPercent) {
        this.bundledLowVolumeFacilityAdjustmentPercent = bundledLowVolumeFacilityAdjustmentPercent;
    }

    @Generated
    public void setBundledOnsetFactor(BigDecimal bundledOnsetFactor) {
        this.bundledOnsetFactor = bundledOnsetFactor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BundledBillingData)) {
            return false;
        }
        BundledBillingData other = (BundledBillingData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$bundledBodyMassIndexFactor = this.getBundledBodyMassIndexFactor();
        BigDecimal other$bundledBodyMassIndexFactor = other.getBundledBodyMassIndexFactor();
        if (this$bundledBodyMassIndexFactor == null ? other$bundledBodyMassIndexFactor != null : !((Object)this$bundledBodyMassIndexFactor).equals(other$bundledBodyMassIndexFactor)) {
            return false;
        }
        BigDecimal this$bundledBodySurfaceAreaFactor = this.getBundledBodySurfaceAreaFactor();
        BigDecimal other$bundledBodySurfaceAreaFactor = other.getBundledBodySurfaceAreaFactor();
        if (this$bundledBodySurfaceAreaFactor == null ? other$bundledBodySurfaceAreaFactor != null : !((Object)this$bundledBodySurfaceAreaFactor).equals(other$bundledBodySurfaceAreaFactor)) {
            return false;
        }
        BigDecimal this$bundledComorbidityMultiplier = this.getBundledComorbidityMultiplier();
        BigDecimal other$bundledComorbidityMultiplier = other.getBundledComorbidityMultiplier();
        if (this$bundledComorbidityMultiplier == null ? other$bundledComorbidityMultiplier != null : !((Object)this$bundledComorbidityMultiplier).equals(other$bundledComorbidityMultiplier)) {
            return false;
        }
        BigDecimal this$bundledLowVolumeFacilityAdjustmentPercent = this.getBundledLowVolumeFacilityAdjustmentPercent();
        BigDecimal other$bundledLowVolumeFacilityAdjustmentPercent = other.getBundledLowVolumeFacilityAdjustmentPercent();
        if (this$bundledLowVolumeFacilityAdjustmentPercent == null ? other$bundledLowVolumeFacilityAdjustmentPercent != null : !((Object)this$bundledLowVolumeFacilityAdjustmentPercent).equals(other$bundledLowVolumeFacilityAdjustmentPercent)) {
            return false;
        }
        BigDecimal this$bundledOnsetFactor = this.getBundledOnsetFactor();
        BigDecimal other$bundledOnsetFactor = other.getBundledOnsetFactor();
        return !(this$bundledOnsetFactor == null ? other$bundledOnsetFactor != null : !((Object)this$bundledOnsetFactor).equals(other$bundledOnsetFactor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BundledBillingData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $bundledBodyMassIndexFactor = this.getBundledBodyMassIndexFactor();
        result = result * 59 + ($bundledBodyMassIndexFactor == null ? 43 : ((Object)$bundledBodyMassIndexFactor).hashCode());
        BigDecimal $bundledBodySurfaceAreaFactor = this.getBundledBodySurfaceAreaFactor();
        result = result * 59 + ($bundledBodySurfaceAreaFactor == null ? 43 : ((Object)$bundledBodySurfaceAreaFactor).hashCode());
        BigDecimal $bundledComorbidityMultiplier = this.getBundledComorbidityMultiplier();
        result = result * 59 + ($bundledComorbidityMultiplier == null ? 43 : ((Object)$bundledComorbidityMultiplier).hashCode());
        BigDecimal $bundledLowVolumeFacilityAdjustmentPercent = this.getBundledLowVolumeFacilityAdjustmentPercent();
        result = result * 59 + ($bundledLowVolumeFacilityAdjustmentPercent == null ? 43 : ((Object)$bundledLowVolumeFacilityAdjustmentPercent).hashCode());
        BigDecimal $bundledOnsetFactor = this.getBundledOnsetFactor();
        result = result * 59 + ($bundledOnsetFactor == null ? 43 : ((Object)$bundledOnsetFactor).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BundledBillingData(bundledBodyMassIndexFactor=" + this.getBundledBodyMassIndexFactor() + ", bundledBodySurfaceAreaFactor=" + this.getBundledBodySurfaceAreaFactor() + ", bundledComorbidityMultiplier=" + this.getBundledComorbidityMultiplier() + ", bundledLowVolumeFacilityAdjustmentPercent=" + this.getBundledLowVolumeFacilityAdjustmentPercent() + ", bundledOnsetFactor=" + this.getBundledOnsetFactor() + ")";
    }

    @Generated
    public BundledBillingData() {
    }
}

