/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

@Schema(description="A demo code and its associated indicators, which can be used to modify the claim processing flow.")
public class DemoCodeData {
    @NotNull
    @Pattern(regexp="\\d{2}", message="must be a two digit number.")
    @Schema(description="A demo code related to the claim.", example="11", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DATA-CODE", value="PIC X(02)")})})
    private @NotNull @Pattern(regexp="\\d{2}", message="must be a two digit number.") String demoCode;
    @ArraySchema(arraySchema=@Schema(description="The indicators related to this demo code.", example="[\"H\"]"), uniqueItems=true)
    @Size(max=5, min=1)
    private @Size(max=5, min=1) List<@Pattern(regexp="^[A-Z0-9]$", message="must be a single alphanumeric character") String> adjustmentIndicators;

    @Generated
    public String getDemoCode() {
        return this.demoCode;
    }

    @Generated
    public List<@Pattern(regexp="^[A-Z0-9]$", message="must be a single alphanumeric character") String> getAdjustmentIndicators() {
        return this.adjustmentIndicators;
    }

    @Generated
    public void setDemoCode(String demoCode) {
        this.demoCode = demoCode;
    }

    @Generated
    public void setAdjustmentIndicators(List<@Pattern(regexp="^[A-Z0-9]$", message="must be a single alphanumeric character") String> adjustmentIndicators) {
        this.adjustmentIndicators = adjustmentIndicators;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DemoCodeData)) {
            return false;
        }
        DemoCodeData other = (DemoCodeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$demoCode = this.getDemoCode();
        String other$demoCode = other.getDemoCode();
        if (this$demoCode == null ? other$demoCode != null : !this$demoCode.equals(other$demoCode)) {
            return false;
        }
        List<String> this$adjustmentIndicators = this.getAdjustmentIndicators();
        List<String> other$adjustmentIndicators = other.getAdjustmentIndicators();
        return !(this$adjustmentIndicators == null ? other$adjustmentIndicators != null : !((Object)this$adjustmentIndicators).equals(other$adjustmentIndicators));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DemoCodeData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $demoCode = this.getDemoCode();
        result = result * 59 + ($demoCode == null ? 43 : $demoCode.hashCode());
        List<String> $adjustmentIndicators = this.getAdjustmentIndicators();
        result = result * 59 + ($adjustmentIndicators == null ? 43 : ((Object)$adjustmentIndicators).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DemoCodeData(demoCode=" + this.getDemoCode() + ", adjustmentIndicators=" + this.getAdjustmentIndicators() + ")";
    }

    @Generated
    public DemoCodeData() {
    }
}

