/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.AdditionalPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.BundledPaymentData;
import gov.cms.fiss.pricers.esrd.api.validation.ValidSignedDecimalOutputWithFourFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;

@Schema(description="The ESRD prospective payment data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DATA", value="<structure>")})})
public class EsrdPaymentData
extends PaymentData {
    @NotNull
    @Schema(description="The additional claim information.")
    @Valid
    private AdditionalPaymentData additionalPaymentInformation = new AdditionalPaymentData();
    @NotNull
    @Schema(description="The additional claim information related to 2011 calculations.")
    @Valid
    private AdditionalPaymentData additionalPaymentInformation2011 = new AdditionalPaymentData();
    @BigDecimalScale(scale=4)
    @NotNull
    @Schema(description="The adjusted base wage amount before the ESRD Treatment Choices (ETC) Home Dialysis Payment Adjustment (HDPA).", example="5137.3689", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="ADJ-BASE-WAGE-BEFORE-ETC-HDPA", value="PIC 9(07)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal adjustedBaseWageBeforeEtcHdpaAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
    @Valid
    private BundledPaymentData bundledPaymentInformation = new BundledPaymentData();
    @BigDecimalScale
    @NotNull
    @Schema(description="The low-volume payment amount.", example="5434.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LOW-VOL-AMT", value="PIC 9(04)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal lowVolumeAmount = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(description="The network reduction amount.", example="1.45", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="NETWORK-REDUCTION-RETURN", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal networkReductionAmount = BigDecimalUtils.ZERO.setScale(2, RoundingMode.UNNECESSARY);
    @BigDecimalScale(scale=4)
    @NotNull
    @Schema(description="The outlier non-per diem payment amount.", example="1238.2345", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-NON-PER-DIEM-PAYMENT", value="PIC 9(07)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal outlierNonPerDiemPaymentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @Schema(example="5137.3689", description="The ESRD Treatment Choices (ETC) Model Performance Payment Adjustment (PPA) amount applied.")
    @ValidSignedDecimalOutputWithFourFractionDigits
    private BigDecimal ppaAdjustmentAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @Schema(description="Line item payment amount before model ETC PPA adjustment.", example="5137.3689")
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal prePpaAdjustmentAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @Schema(description="Line item payment amount after model ETC PPA adjustment. Final ESRD PPS per Treatment Payment Amount with PPA.", example="5137.3689")
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal postPpaAdjustmentAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @Schema(description="The Transitional Drug Add-on Payment Adjustment (TDAPA) adjustment amount.", example="31584.7863", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="TDAPA-RETURN", value="PIC 9(07)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal tdapaPaymentAdjustmentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @Schema(description="The Transitional Add-on Payment Adjustment for New and Innovative Equipment and Supplies (TPNIES) amount for capital-related assets (CRA).", example="468752.8461")
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal tpniesCraPaymentAdjustmentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @Schema(description="The Transitional Add-on Payment Adjustment for New and Innovative Equipment and Supplies (TPNIES) amount.", example="468752.8461", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="TPNIES-RETURN", value="PIC 9(07)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal tpniesPaymentAdjustmentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @Schema(description="The ESRD Treatment Choices (ETC) Home Dialysis Payment Adjustment (HDPA) amount applied.", example="5137.3689")
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal hdpaAdjustmentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @Schema(description="Final Wage Index", example="01.0123")
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal finalWageIndex = BigDecimalUtils.ZERO.setScale(4, RoundingMode.UNNECESSARY);

    @Generated
    public AdditionalPaymentData getAdditionalPaymentInformation() {
        return this.additionalPaymentInformation;
    }

    @Generated
    public AdditionalPaymentData getAdditionalPaymentInformation2011() {
        return this.additionalPaymentInformation2011;
    }

    @Generated
    public BigDecimal getAdjustedBaseWageBeforeEtcHdpaAmount() {
        return this.adjustedBaseWageBeforeEtcHdpaAmount;
    }

    @Generated
    public BundledPaymentData getBundledPaymentInformation() {
        return this.bundledPaymentInformation;
    }

    @Generated
    public BigDecimal getLowVolumeAmount() {
        return this.lowVolumeAmount;
    }

    @Generated
    public BigDecimal getNetworkReductionAmount() {
        return this.networkReductionAmount;
    }

    @Generated
    public BigDecimal getOutlierNonPerDiemPaymentAmount() {
        return this.outlierNonPerDiemPaymentAmount;
    }

    @Generated
    public BigDecimal getPpaAdjustmentAmount() {
        return this.ppaAdjustmentAmount;
    }

    @Generated
    public BigDecimal getPrePpaAdjustmentAmount() {
        return this.prePpaAdjustmentAmount;
    }

    @Generated
    public BigDecimal getPostPpaAdjustmentAmount() {
        return this.postPpaAdjustmentAmount;
    }

    @Generated
    public BigDecimal getTdapaPaymentAdjustmentAmount() {
        return this.tdapaPaymentAdjustmentAmount;
    }

    @Generated
    public BigDecimal getTpniesCraPaymentAdjustmentAmount() {
        return this.tpniesCraPaymentAdjustmentAmount;
    }

    @Generated
    public BigDecimal getTpniesPaymentAdjustmentAmount() {
        return this.tpniesPaymentAdjustmentAmount;
    }

    @Generated
    public BigDecimal getHdpaAdjustmentAmount() {
        return this.hdpaAdjustmentAmount;
    }

    @Override
    @Generated
    public BigDecimal getFinalWageIndex() {
        return this.finalWageIndex;
    }

    @Generated
    public void setAdditionalPaymentInformation(AdditionalPaymentData additionalPaymentInformation) {
        this.additionalPaymentInformation = additionalPaymentInformation;
    }

    @Generated
    public void setAdditionalPaymentInformation2011(AdditionalPaymentData additionalPaymentInformation2011) {
        this.additionalPaymentInformation2011 = additionalPaymentInformation2011;
    }

    @Generated
    public void setAdjustedBaseWageBeforeEtcHdpaAmount(BigDecimal adjustedBaseWageBeforeEtcHdpaAmount) {
        this.adjustedBaseWageBeforeEtcHdpaAmount = adjustedBaseWageBeforeEtcHdpaAmount;
    }

    @Generated
    public void setBundledPaymentInformation(BundledPaymentData bundledPaymentInformation) {
        this.bundledPaymentInformation = bundledPaymentInformation;
    }

    @Generated
    public void setLowVolumeAmount(BigDecimal lowVolumeAmount) {
        this.lowVolumeAmount = lowVolumeAmount;
    }

    @Generated
    public void setNetworkReductionAmount(BigDecimal networkReductionAmount) {
        this.networkReductionAmount = networkReductionAmount;
    }

    @Generated
    public void setOutlierNonPerDiemPaymentAmount(BigDecimal outlierNonPerDiemPaymentAmount) {
        this.outlierNonPerDiemPaymentAmount = outlierNonPerDiemPaymentAmount;
    }

    @Generated
    public void setPpaAdjustmentAmount(BigDecimal ppaAdjustmentAmount) {
        this.ppaAdjustmentAmount = ppaAdjustmentAmount;
    }

    @Generated
    public void setPrePpaAdjustmentAmount(BigDecimal prePpaAdjustmentAmount) {
        this.prePpaAdjustmentAmount = prePpaAdjustmentAmount;
    }

    @Generated
    public void setPostPpaAdjustmentAmount(BigDecimal postPpaAdjustmentAmount) {
        this.postPpaAdjustmentAmount = postPpaAdjustmentAmount;
    }

    @Generated
    public void setTdapaPaymentAdjustmentAmount(BigDecimal tdapaPaymentAdjustmentAmount) {
        this.tdapaPaymentAdjustmentAmount = tdapaPaymentAdjustmentAmount;
    }

    @Generated
    public void setTpniesCraPaymentAdjustmentAmount(BigDecimal tpniesCraPaymentAdjustmentAmount) {
        this.tpniesCraPaymentAdjustmentAmount = tpniesCraPaymentAdjustmentAmount;
    }

    @Generated
    public void setTpniesPaymentAdjustmentAmount(BigDecimal tpniesPaymentAdjustmentAmount) {
        this.tpniesPaymentAdjustmentAmount = tpniesPaymentAdjustmentAmount;
    }

    @Generated
    public void setHdpaAdjustmentAmount(BigDecimal hdpaAdjustmentAmount) {
        this.hdpaAdjustmentAmount = hdpaAdjustmentAmount;
    }

    @Override
    @Generated
    public void setFinalWageIndex(BigDecimal finalWageIndex) {
        this.finalWageIndex = finalWageIndex;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsrdPaymentData)) {
            return false;
        }
        EsrdPaymentData other = (EsrdPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdditionalPaymentData this$additionalPaymentInformation = this.getAdditionalPaymentInformation();
        AdditionalPaymentData other$additionalPaymentInformation = other.getAdditionalPaymentInformation();
        if (this$additionalPaymentInformation == null ? other$additionalPaymentInformation != null : !((Object)this$additionalPaymentInformation).equals(other$additionalPaymentInformation)) {
            return false;
        }
        AdditionalPaymentData this$additionalPaymentInformation2011 = this.getAdditionalPaymentInformation2011();
        AdditionalPaymentData other$additionalPaymentInformation2011 = other.getAdditionalPaymentInformation2011();
        if (this$additionalPaymentInformation2011 == null ? other$additionalPaymentInformation2011 != null : !((Object)this$additionalPaymentInformation2011).equals(other$additionalPaymentInformation2011)) {
            return false;
        }
        BigDecimal this$adjustedBaseWageBeforeEtcHdpaAmount = this.getAdjustedBaseWageBeforeEtcHdpaAmount();
        BigDecimal other$adjustedBaseWageBeforeEtcHdpaAmount = other.getAdjustedBaseWageBeforeEtcHdpaAmount();
        if (this$adjustedBaseWageBeforeEtcHdpaAmount == null ? other$adjustedBaseWageBeforeEtcHdpaAmount != null : !((Object)this$adjustedBaseWageBeforeEtcHdpaAmount).equals(other$adjustedBaseWageBeforeEtcHdpaAmount)) {
            return false;
        }
        BundledPaymentData this$bundledPaymentInformation = this.getBundledPaymentInformation();
        BundledPaymentData other$bundledPaymentInformation = other.getBundledPaymentInformation();
        if (this$bundledPaymentInformation == null ? other$bundledPaymentInformation != null : !((Object)this$bundledPaymentInformation).equals(other$bundledPaymentInformation)) {
            return false;
        }
        BigDecimal this$lowVolumeAmount = this.getLowVolumeAmount();
        BigDecimal other$lowVolumeAmount = other.getLowVolumeAmount();
        if (this$lowVolumeAmount == null ? other$lowVolumeAmount != null : !((Object)this$lowVolumeAmount).equals(other$lowVolumeAmount)) {
            return false;
        }
        BigDecimal this$networkReductionAmount = this.getNetworkReductionAmount();
        BigDecimal other$networkReductionAmount = other.getNetworkReductionAmount();
        if (this$networkReductionAmount == null ? other$networkReductionAmount != null : !((Object)this$networkReductionAmount).equals(other$networkReductionAmount)) {
            return false;
        }
        BigDecimal this$outlierNonPerDiemPaymentAmount = this.getOutlierNonPerDiemPaymentAmount();
        BigDecimal other$outlierNonPerDiemPaymentAmount = other.getOutlierNonPerDiemPaymentAmount();
        if (this$outlierNonPerDiemPaymentAmount == null ? other$outlierNonPerDiemPaymentAmount != null : !((Object)this$outlierNonPerDiemPaymentAmount).equals(other$outlierNonPerDiemPaymentAmount)) {
            return false;
        }
        BigDecimal this$ppaAdjustmentAmount = this.getPpaAdjustmentAmount();
        BigDecimal other$ppaAdjustmentAmount = other.getPpaAdjustmentAmount();
        if (this$ppaAdjustmentAmount == null ? other$ppaAdjustmentAmount != null : !((Object)this$ppaAdjustmentAmount).equals(other$ppaAdjustmentAmount)) {
            return false;
        }
        BigDecimal this$prePpaAdjustmentAmount = this.getPrePpaAdjustmentAmount();
        BigDecimal other$prePpaAdjustmentAmount = other.getPrePpaAdjustmentAmount();
        if (this$prePpaAdjustmentAmount == null ? other$prePpaAdjustmentAmount != null : !((Object)this$prePpaAdjustmentAmount).equals(other$prePpaAdjustmentAmount)) {
            return false;
        }
        BigDecimal this$postPpaAdjustmentAmount = this.getPostPpaAdjustmentAmount();
        BigDecimal other$postPpaAdjustmentAmount = other.getPostPpaAdjustmentAmount();
        if (this$postPpaAdjustmentAmount == null ? other$postPpaAdjustmentAmount != null : !((Object)this$postPpaAdjustmentAmount).equals(other$postPpaAdjustmentAmount)) {
            return false;
        }
        BigDecimal this$tdapaPaymentAdjustmentAmount = this.getTdapaPaymentAdjustmentAmount();
        BigDecimal other$tdapaPaymentAdjustmentAmount = other.getTdapaPaymentAdjustmentAmount();
        if (this$tdapaPaymentAdjustmentAmount == null ? other$tdapaPaymentAdjustmentAmount != null : !((Object)this$tdapaPaymentAdjustmentAmount).equals(other$tdapaPaymentAdjustmentAmount)) {
            return false;
        }
        BigDecimal this$tpniesCraPaymentAdjustmentAmount = this.getTpniesCraPaymentAdjustmentAmount();
        BigDecimal other$tpniesCraPaymentAdjustmentAmount = other.getTpniesCraPaymentAdjustmentAmount();
        if (this$tpniesCraPaymentAdjustmentAmount == null ? other$tpniesCraPaymentAdjustmentAmount != null : !((Object)this$tpniesCraPaymentAdjustmentAmount).equals(other$tpniesCraPaymentAdjustmentAmount)) {
            return false;
        }
        BigDecimal this$tpniesPaymentAdjustmentAmount = this.getTpniesPaymentAdjustmentAmount();
        BigDecimal other$tpniesPaymentAdjustmentAmount = other.getTpniesPaymentAdjustmentAmount();
        if (this$tpniesPaymentAdjustmentAmount == null ? other$tpniesPaymentAdjustmentAmount != null : !((Object)this$tpniesPaymentAdjustmentAmount).equals(other$tpniesPaymentAdjustmentAmount)) {
            return false;
        }
        BigDecimal this$hdpaAdjustmentAmount = this.getHdpaAdjustmentAmount();
        BigDecimal other$hdpaAdjustmentAmount = other.getHdpaAdjustmentAmount();
        if (this$hdpaAdjustmentAmount == null ? other$hdpaAdjustmentAmount != null : !((Object)this$hdpaAdjustmentAmount).equals(other$hdpaAdjustmentAmount)) {
            return false;
        }
        BigDecimal this$finalWageIndex = this.getFinalWageIndex();
        BigDecimal other$finalWageIndex = other.getFinalWageIndex();
        return !(this$finalWageIndex == null ? other$finalWageIndex != null : !((Object)this$finalWageIndex).equals(other$finalWageIndex));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EsrdPaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AdditionalPaymentData $additionalPaymentInformation = this.getAdditionalPaymentInformation();
        result = result * 59 + ($additionalPaymentInformation == null ? 43 : ((Object)$additionalPaymentInformation).hashCode());
        AdditionalPaymentData $additionalPaymentInformation2011 = this.getAdditionalPaymentInformation2011();
        result = result * 59 + ($additionalPaymentInformation2011 == null ? 43 : ((Object)$additionalPaymentInformation2011).hashCode());
        BigDecimal $adjustedBaseWageBeforeEtcHdpaAmount = this.getAdjustedBaseWageBeforeEtcHdpaAmount();
        result = result * 59 + ($adjustedBaseWageBeforeEtcHdpaAmount == null ? 43 : ((Object)$adjustedBaseWageBeforeEtcHdpaAmount).hashCode());
        BundledPaymentData $bundledPaymentInformation = this.getBundledPaymentInformation();
        result = result * 59 + ($bundledPaymentInformation == null ? 43 : ((Object)$bundledPaymentInformation).hashCode());
        BigDecimal $lowVolumeAmount = this.getLowVolumeAmount();
        result = result * 59 + ($lowVolumeAmount == null ? 43 : ((Object)$lowVolumeAmount).hashCode());
        BigDecimal $networkReductionAmount = this.getNetworkReductionAmount();
        result = result * 59 + ($networkReductionAmount == null ? 43 : ((Object)$networkReductionAmount).hashCode());
        BigDecimal $outlierNonPerDiemPaymentAmount = this.getOutlierNonPerDiemPaymentAmount();
        result = result * 59 + ($outlierNonPerDiemPaymentAmount == null ? 43 : ((Object)$outlierNonPerDiemPaymentAmount).hashCode());
        BigDecimal $ppaAdjustmentAmount = this.getPpaAdjustmentAmount();
        result = result * 59 + ($ppaAdjustmentAmount == null ? 43 : ((Object)$ppaAdjustmentAmount).hashCode());
        BigDecimal $prePpaAdjustmentAmount = this.getPrePpaAdjustmentAmount();
        result = result * 59 + ($prePpaAdjustmentAmount == null ? 43 : ((Object)$prePpaAdjustmentAmount).hashCode());
        BigDecimal $postPpaAdjustmentAmount = this.getPostPpaAdjustmentAmount();
        result = result * 59 + ($postPpaAdjustmentAmount == null ? 43 : ((Object)$postPpaAdjustmentAmount).hashCode());
        BigDecimal $tdapaPaymentAdjustmentAmount = this.getTdapaPaymentAdjustmentAmount();
        result = result * 59 + ($tdapaPaymentAdjustmentAmount == null ? 43 : ((Object)$tdapaPaymentAdjustmentAmount).hashCode());
        BigDecimal $tpniesCraPaymentAdjustmentAmount = this.getTpniesCraPaymentAdjustmentAmount();
        result = result * 59 + ($tpniesCraPaymentAdjustmentAmount == null ? 43 : ((Object)$tpniesCraPaymentAdjustmentAmount).hashCode());
        BigDecimal $tpniesPaymentAdjustmentAmount = this.getTpniesPaymentAdjustmentAmount();
        result = result * 59 + ($tpniesPaymentAdjustmentAmount == null ? 43 : ((Object)$tpniesPaymentAdjustmentAmount).hashCode());
        BigDecimal $hdpaAdjustmentAmount = this.getHdpaAdjustmentAmount();
        result = result * 59 + ($hdpaAdjustmentAmount == null ? 43 : ((Object)$hdpaAdjustmentAmount).hashCode());
        BigDecimal $finalWageIndex = this.getFinalWageIndex();
        result = result * 59 + ($finalWageIndex == null ? 43 : ((Object)$finalWageIndex).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "EsrdPaymentData(additionalPaymentInformation=" + this.getAdditionalPaymentInformation() + ", additionalPaymentInformation2011=" + this.getAdditionalPaymentInformation2011() + ", adjustedBaseWageBeforeEtcHdpaAmount=" + this.getAdjustedBaseWageBeforeEtcHdpaAmount() + ", bundledPaymentInformation=" + this.getBundledPaymentInformation() + ", lowVolumeAmount=" + this.getLowVolumeAmount() + ", networkReductionAmount=" + this.getNetworkReductionAmount() + ", outlierNonPerDiemPaymentAmount=" + this.getOutlierNonPerDiemPaymentAmount() + ", ppaAdjustmentAmount=" + this.getPpaAdjustmentAmount() + ", prePpaAdjustmentAmount=" + this.getPrePpaAdjustmentAmount() + ", postPpaAdjustmentAmount=" + this.getPostPpaAdjustmentAmount() + ", tdapaPaymentAdjustmentAmount=" + this.getTdapaPaymentAdjustmentAmount() + ", tpniesCraPaymentAdjustmentAmount=" + this.getTpniesCraPaymentAdjustmentAmount() + ", tpniesPaymentAdjustmentAmount=" + this.getTpniesPaymentAdjustmentAmount() + ", hdpaAdjustmentAmount=" + this.getHdpaAdjustmentAmount() + ", finalWageIndex=" + this.getFinalWageIndex() + ")";
    }

    @Generated
    public EsrdPaymentData() {
    }
}

