/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="The outlier billing information for display; separate from the claim pricing result.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-DATA-TEST", value="<structure>")})})
public class OutlierBillingData {
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(example="1.017", description="The outlier age factor.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-AGE-FACTOR", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal outlierAgeAdjustmentFactor;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="999.99")
    @Digits(integer=3, fraction=2)
    @Schema(example="233.45", description="The outlier adjusted average Medicare-allowable payment (MAP) amount.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-ADJ-AVG-MAP-AMT", value="PIC 9(03)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="999.99") @Digits(integer=3, fraction=2) @FixedValue BigDecimal outlierAverageAdjustedMapAmount;
    @BigDecimalScale(scale=4)
    @Schema(example="13.4534", description="The outlier body-mass index (BMI).", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-BMI", value="PIC 9(03)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal outlierBodyMassIndex;
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(example="1.0683", description="The outlier body mass index (BMI) adjustment factor used.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-BMI-FACTOR", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal outlierBodyMassIndexFactor;
    @BigDecimalScale(scale=4)
    @Schema(example="13.4534", description="The outlier body surface area (BSA).", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-BSA", value="PIC 9(03)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal outlierBodySurfaceArea;
    @BigDecimalScale(scale=4)
    @Schema(example="1.0683", description="The body surface area (BSA) adjustment factor used.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-BSA-FACTOR", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal outlierBodySurfaceAreaFactor;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(example="1.017", description="The outlier comorbidity multiplier.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-COMORBID-MULTIPLIER", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal outlierComorbidityMultiplier;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999.99")
    @Digits(integer=4, fraction=2)
    @Schema(example="902.23", description="The outlier fixed dollar loss amount.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-FIX-DOLLAR-LOSS", value="PIC 9(04)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999.99") @Digits(integer=4, fraction=2) @FixedValue BigDecimal outlierFixedDollarLossAmount;
    @BigDecimalScale(scale=4)
    @Schema(example="1238.4534", description="The outlier imputed Medicare-allowable payment (MAP) amount.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-IMPUTED-MAP", value="PIC 9(04)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal outlierImputedMapAmount;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(example="1.01", description="The outlier loss-sharing percent.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-LOSS-SHARING-PCT", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal outlierLossSharingPercent;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(example="1.017", description="The outlier low-volume multiplier.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-LOW-VOL-MULTIPLIER", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal outlierLowVolumeMultiplier;
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(example="1.0683", description="The outlier onset factor used.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-ONSET-FACTOR", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal outlierOnsetFactor;
    @BigDecimalScale(scale=4)
    @Schema(example="29873.3465", description="The outlier predicted Medicare-allowable payment (MAP) amount.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-PREDICTED-MAP", value="PIC 9(07)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal outlierPredictedMapAmount;
    @BigDecimalScale(scale=4)
    @Schema(example="23.2684", description="The outlier predicted Medicare-allowable payment (MAP) amount.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-PREDICTED-SERVICES-MAP", value="PIC 9(02)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal outlierPredictedServicesMapAmount;

    @Generated
    public BigDecimal getOutlierAgeAdjustmentFactor() {
        return this.outlierAgeAdjustmentFactor;
    }

    @Generated
    public BigDecimal getOutlierAverageAdjustedMapAmount() {
        return this.outlierAverageAdjustedMapAmount;
    }

    @Generated
    public BigDecimal getOutlierBodyMassIndex() {
        return this.outlierBodyMassIndex;
    }

    @Generated
    public BigDecimal getOutlierBodyMassIndexFactor() {
        return this.outlierBodyMassIndexFactor;
    }

    @Generated
    public BigDecimal getOutlierBodySurfaceArea() {
        return this.outlierBodySurfaceArea;
    }

    @Generated
    public BigDecimal getOutlierBodySurfaceAreaFactor() {
        return this.outlierBodySurfaceAreaFactor;
    }

    @Generated
    public BigDecimal getOutlierComorbidityMultiplier() {
        return this.outlierComorbidityMultiplier;
    }

    @Generated
    public BigDecimal getOutlierFixedDollarLossAmount() {
        return this.outlierFixedDollarLossAmount;
    }

    @Generated
    public BigDecimal getOutlierImputedMapAmount() {
        return this.outlierImputedMapAmount;
    }

    @Generated
    public BigDecimal getOutlierLossSharingPercent() {
        return this.outlierLossSharingPercent;
    }

    @Generated
    public BigDecimal getOutlierLowVolumeMultiplier() {
        return this.outlierLowVolumeMultiplier;
    }

    @Generated
    public BigDecimal getOutlierOnsetFactor() {
        return this.outlierOnsetFactor;
    }

    @Generated
    public BigDecimal getOutlierPredictedMapAmount() {
        return this.outlierPredictedMapAmount;
    }

    @Generated
    public BigDecimal getOutlierPredictedServicesMapAmount() {
        return this.outlierPredictedServicesMapAmount;
    }

    @Generated
    public void setOutlierAgeAdjustmentFactor(BigDecimal outlierAgeAdjustmentFactor) {
        this.outlierAgeAdjustmentFactor = outlierAgeAdjustmentFactor;
    }

    @Generated
    public void setOutlierAverageAdjustedMapAmount(BigDecimal outlierAverageAdjustedMapAmount) {
        this.outlierAverageAdjustedMapAmount = outlierAverageAdjustedMapAmount;
    }

    @Generated
    public void setOutlierBodyMassIndex(BigDecimal outlierBodyMassIndex) {
        this.outlierBodyMassIndex = outlierBodyMassIndex;
    }

    @Generated
    public void setOutlierBodyMassIndexFactor(BigDecimal outlierBodyMassIndexFactor) {
        this.outlierBodyMassIndexFactor = outlierBodyMassIndexFactor;
    }

    @Generated
    public void setOutlierBodySurfaceArea(BigDecimal outlierBodySurfaceArea) {
        this.outlierBodySurfaceArea = outlierBodySurfaceArea;
    }

    @Generated
    public void setOutlierBodySurfaceAreaFactor(BigDecimal outlierBodySurfaceAreaFactor) {
        this.outlierBodySurfaceAreaFactor = outlierBodySurfaceAreaFactor;
    }

    @Generated
    public void setOutlierComorbidityMultiplier(BigDecimal outlierComorbidityMultiplier) {
        this.outlierComorbidityMultiplier = outlierComorbidityMultiplier;
    }

    @Generated
    public void setOutlierFixedDollarLossAmount(BigDecimal outlierFixedDollarLossAmount) {
        this.outlierFixedDollarLossAmount = outlierFixedDollarLossAmount;
    }

    @Generated
    public void setOutlierImputedMapAmount(BigDecimal outlierImputedMapAmount) {
        this.outlierImputedMapAmount = outlierImputedMapAmount;
    }

    @Generated
    public void setOutlierLossSharingPercent(BigDecimal outlierLossSharingPercent) {
        this.outlierLossSharingPercent = outlierLossSharingPercent;
    }

    @Generated
    public void setOutlierLowVolumeMultiplier(BigDecimal outlierLowVolumeMultiplier) {
        this.outlierLowVolumeMultiplier = outlierLowVolumeMultiplier;
    }

    @Generated
    public void setOutlierOnsetFactor(BigDecimal outlierOnsetFactor) {
        this.outlierOnsetFactor = outlierOnsetFactor;
    }

    @Generated
    public void setOutlierPredictedMapAmount(BigDecimal outlierPredictedMapAmount) {
        this.outlierPredictedMapAmount = outlierPredictedMapAmount;
    }

    @Generated
    public void setOutlierPredictedServicesMapAmount(BigDecimal outlierPredictedServicesMapAmount) {
        this.outlierPredictedServicesMapAmount = outlierPredictedServicesMapAmount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutlierBillingData)) {
            return false;
        }
        OutlierBillingData other = (OutlierBillingData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$outlierAgeAdjustmentFactor = this.getOutlierAgeAdjustmentFactor();
        BigDecimal other$outlierAgeAdjustmentFactor = other.getOutlierAgeAdjustmentFactor();
        if (this$outlierAgeAdjustmentFactor == null ? other$outlierAgeAdjustmentFactor != null : !((Object)this$outlierAgeAdjustmentFactor).equals(other$outlierAgeAdjustmentFactor)) {
            return false;
        }
        BigDecimal this$outlierAverageAdjustedMapAmount = this.getOutlierAverageAdjustedMapAmount();
        BigDecimal other$outlierAverageAdjustedMapAmount = other.getOutlierAverageAdjustedMapAmount();
        if (this$outlierAverageAdjustedMapAmount == null ? other$outlierAverageAdjustedMapAmount != null : !((Object)this$outlierAverageAdjustedMapAmount).equals(other$outlierAverageAdjustedMapAmount)) {
            return false;
        }
        BigDecimal this$outlierBodyMassIndex = this.getOutlierBodyMassIndex();
        BigDecimal other$outlierBodyMassIndex = other.getOutlierBodyMassIndex();
        if (this$outlierBodyMassIndex == null ? other$outlierBodyMassIndex != null : !((Object)this$outlierBodyMassIndex).equals(other$outlierBodyMassIndex)) {
            return false;
        }
        BigDecimal this$outlierBodyMassIndexFactor = this.getOutlierBodyMassIndexFactor();
        BigDecimal other$outlierBodyMassIndexFactor = other.getOutlierBodyMassIndexFactor();
        if (this$outlierBodyMassIndexFactor == null ? other$outlierBodyMassIndexFactor != null : !((Object)this$outlierBodyMassIndexFactor).equals(other$outlierBodyMassIndexFactor)) {
            return false;
        }
        BigDecimal this$outlierBodySurfaceArea = this.getOutlierBodySurfaceArea();
        BigDecimal other$outlierBodySurfaceArea = other.getOutlierBodySurfaceArea();
        if (this$outlierBodySurfaceArea == null ? other$outlierBodySurfaceArea != null : !((Object)this$outlierBodySurfaceArea).equals(other$outlierBodySurfaceArea)) {
            return false;
        }
        BigDecimal this$outlierBodySurfaceAreaFactor = this.getOutlierBodySurfaceAreaFactor();
        BigDecimal other$outlierBodySurfaceAreaFactor = other.getOutlierBodySurfaceAreaFactor();
        if (this$outlierBodySurfaceAreaFactor == null ? other$outlierBodySurfaceAreaFactor != null : !((Object)this$outlierBodySurfaceAreaFactor).equals(other$outlierBodySurfaceAreaFactor)) {
            return false;
        }
        BigDecimal this$outlierComorbidityMultiplier = this.getOutlierComorbidityMultiplier();
        BigDecimal other$outlierComorbidityMultiplier = other.getOutlierComorbidityMultiplier();
        if (this$outlierComorbidityMultiplier == null ? other$outlierComorbidityMultiplier != null : !((Object)this$outlierComorbidityMultiplier).equals(other$outlierComorbidityMultiplier)) {
            return false;
        }
        BigDecimal this$outlierFixedDollarLossAmount = this.getOutlierFixedDollarLossAmount();
        BigDecimal other$outlierFixedDollarLossAmount = other.getOutlierFixedDollarLossAmount();
        if (this$outlierFixedDollarLossAmount == null ? other$outlierFixedDollarLossAmount != null : !((Object)this$outlierFixedDollarLossAmount).equals(other$outlierFixedDollarLossAmount)) {
            return false;
        }
        BigDecimal this$outlierImputedMapAmount = this.getOutlierImputedMapAmount();
        BigDecimal other$outlierImputedMapAmount = other.getOutlierImputedMapAmount();
        if (this$outlierImputedMapAmount == null ? other$outlierImputedMapAmount != null : !((Object)this$outlierImputedMapAmount).equals(other$outlierImputedMapAmount)) {
            return false;
        }
        BigDecimal this$outlierLossSharingPercent = this.getOutlierLossSharingPercent();
        BigDecimal other$outlierLossSharingPercent = other.getOutlierLossSharingPercent();
        if (this$outlierLossSharingPercent == null ? other$outlierLossSharingPercent != null : !((Object)this$outlierLossSharingPercent).equals(other$outlierLossSharingPercent)) {
            return false;
        }
        BigDecimal this$outlierLowVolumeMultiplier = this.getOutlierLowVolumeMultiplier();
        BigDecimal other$outlierLowVolumeMultiplier = other.getOutlierLowVolumeMultiplier();
        if (this$outlierLowVolumeMultiplier == null ? other$outlierLowVolumeMultiplier != null : !((Object)this$outlierLowVolumeMultiplier).equals(other$outlierLowVolumeMultiplier)) {
            return false;
        }
        BigDecimal this$outlierOnsetFactor = this.getOutlierOnsetFactor();
        BigDecimal other$outlierOnsetFactor = other.getOutlierOnsetFactor();
        if (this$outlierOnsetFactor == null ? other$outlierOnsetFactor != null : !((Object)this$outlierOnsetFactor).equals(other$outlierOnsetFactor)) {
            return false;
        }
        BigDecimal this$outlierPredictedMapAmount = this.getOutlierPredictedMapAmount();
        BigDecimal other$outlierPredictedMapAmount = other.getOutlierPredictedMapAmount();
        if (this$outlierPredictedMapAmount == null ? other$outlierPredictedMapAmount != null : !((Object)this$outlierPredictedMapAmount).equals(other$outlierPredictedMapAmount)) {
            return false;
        }
        BigDecimal this$outlierPredictedServicesMapAmount = this.getOutlierPredictedServicesMapAmount();
        BigDecimal other$outlierPredictedServicesMapAmount = other.getOutlierPredictedServicesMapAmount();
        return !(this$outlierPredictedServicesMapAmount == null ? other$outlierPredictedServicesMapAmount != null : !((Object)this$outlierPredictedServicesMapAmount).equals(other$outlierPredictedServicesMapAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutlierBillingData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $outlierAgeAdjustmentFactor = this.getOutlierAgeAdjustmentFactor();
        result = result * 59 + ($outlierAgeAdjustmentFactor == null ? 43 : ((Object)$outlierAgeAdjustmentFactor).hashCode());
        BigDecimal $outlierAverageAdjustedMapAmount = this.getOutlierAverageAdjustedMapAmount();
        result = result * 59 + ($outlierAverageAdjustedMapAmount == null ? 43 : ((Object)$outlierAverageAdjustedMapAmount).hashCode());
        BigDecimal $outlierBodyMassIndex = this.getOutlierBodyMassIndex();
        result = result * 59 + ($outlierBodyMassIndex == null ? 43 : ((Object)$outlierBodyMassIndex).hashCode());
        BigDecimal $outlierBodyMassIndexFactor = this.getOutlierBodyMassIndexFactor();
        result = result * 59 + ($outlierBodyMassIndexFactor == null ? 43 : ((Object)$outlierBodyMassIndexFactor).hashCode());
        BigDecimal $outlierBodySurfaceArea = this.getOutlierBodySurfaceArea();
        result = result * 59 + ($outlierBodySurfaceArea == null ? 43 : ((Object)$outlierBodySurfaceArea).hashCode());
        BigDecimal $outlierBodySurfaceAreaFactor = this.getOutlierBodySurfaceAreaFactor();
        result = result * 59 + ($outlierBodySurfaceAreaFactor == null ? 43 : ((Object)$outlierBodySurfaceAreaFactor).hashCode());
        BigDecimal $outlierComorbidityMultiplier = this.getOutlierComorbidityMultiplier();
        result = result * 59 + ($outlierComorbidityMultiplier == null ? 43 : ((Object)$outlierComorbidityMultiplier).hashCode());
        BigDecimal $outlierFixedDollarLossAmount = this.getOutlierFixedDollarLossAmount();
        result = result * 59 + ($outlierFixedDollarLossAmount == null ? 43 : ((Object)$outlierFixedDollarLossAmount).hashCode());
        BigDecimal $outlierImputedMapAmount = this.getOutlierImputedMapAmount();
        result = result * 59 + ($outlierImputedMapAmount == null ? 43 : ((Object)$outlierImputedMapAmount).hashCode());
        BigDecimal $outlierLossSharingPercent = this.getOutlierLossSharingPercent();
        result = result * 59 + ($outlierLossSharingPercent == null ? 43 : ((Object)$outlierLossSharingPercent).hashCode());
        BigDecimal $outlierLowVolumeMultiplier = this.getOutlierLowVolumeMultiplier();
        result = result * 59 + ($outlierLowVolumeMultiplier == null ? 43 : ((Object)$outlierLowVolumeMultiplier).hashCode());
        BigDecimal $outlierOnsetFactor = this.getOutlierOnsetFactor();
        result = result * 59 + ($outlierOnsetFactor == null ? 43 : ((Object)$outlierOnsetFactor).hashCode());
        BigDecimal $outlierPredictedMapAmount = this.getOutlierPredictedMapAmount();
        result = result * 59 + ($outlierPredictedMapAmount == null ? 43 : ((Object)$outlierPredictedMapAmount).hashCode());
        BigDecimal $outlierPredictedServicesMapAmount = this.getOutlierPredictedServicesMapAmount();
        result = result * 59 + ($outlierPredictedServicesMapAmount == null ? 43 : ((Object)$outlierPredictedServicesMapAmount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutlierBillingData(outlierAgeAdjustmentFactor=" + this.getOutlierAgeAdjustmentFactor() + ", outlierAverageAdjustedMapAmount=" + this.getOutlierAverageAdjustedMapAmount() + ", outlierBodyMassIndex=" + this.getOutlierBodyMassIndex() + ", outlierBodyMassIndexFactor=" + this.getOutlierBodyMassIndexFactor() + ", outlierBodySurfaceArea=" + this.getOutlierBodySurfaceArea() + ", outlierBodySurfaceAreaFactor=" + this.getOutlierBodySurfaceAreaFactor() + ", outlierComorbidityMultiplier=" + this.getOutlierComorbidityMultiplier() + ", outlierFixedDollarLossAmount=" + this.getOutlierFixedDollarLossAmount() + ", outlierImputedMapAmount=" + this.getOutlierImputedMapAmount() + ", outlierLossSharingPercent=" + this.getOutlierLossSharingPercent() + ", outlierLowVolumeMultiplier=" + this.getOutlierLowVolumeMultiplier() + ", outlierOnsetFactor=" + this.getOutlierOnsetFactor() + ", outlierPredictedMapAmount=" + this.getOutlierPredictedMapAmount() + ", outlierPredictedServicesMapAmount=" + this.getOutlierPredictedServicesMapAmount() + ")";
    }

    @Generated
    public OutlierBillingData() {
    }
}

