/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="The payment billing information for display; separate from the claim pricing result.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-DATA-TEST", value="<structure>")})})
public class PaymentBillingData {
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The bundled core-based statistical area (CBSA) blend percent.", example="0.75", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BUN-CBSA-PCT-BLEND", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal bundledCbsaBlendPercent;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The core-based statistical area (CBSA) percentage factor (as compared to the metropolitan statistical area (MSA) percentage).", example="0.63", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="CBSA-PCT", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal cbsaPercent;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999.99")
    @Digits(integer=4, fraction=2)
    @Schema(description="The core-based statistical area (CBSA) wage payment rate.", example="3265.44", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="CBSA-WAGE-PMT-RATE", value="PIC 9(04)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999.99") @Digits(integer=4, fraction=2) @FixedValue BigDecimal cbsaWagePaymentRate;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The composite core-based statistical area (CBSA) blend percent.", example="0.20", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="COM-CBSA-PCT-BLEND", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal compositeCbsaBlendPercent;
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(description="The drug add-on amount.", example="8.3305", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="DRUG-ADD-ON-RETURN", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal drugAddOnAmount;
    @Max(value=999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The patient age for the purposes of claim pricing.", example="27", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="AGE-RETURN", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) @NotNull Integer patientAge = 0;

    @Generated
    public BigDecimal getBundledCbsaBlendPercent() {
        return this.bundledCbsaBlendPercent;
    }

    @Generated
    public BigDecimal getCbsaPercent() {
        return this.cbsaPercent;
    }

    @Generated
    public BigDecimal getCbsaWagePaymentRate() {
        return this.cbsaWagePaymentRate;
    }

    @Generated
    public BigDecimal getCompositeCbsaBlendPercent() {
        return this.compositeCbsaBlendPercent;
    }

    @Generated
    public BigDecimal getDrugAddOnAmount() {
        return this.drugAddOnAmount;
    }

    @Generated
    public Integer getPatientAge() {
        return this.patientAge;
    }

    @Generated
    public void setBundledCbsaBlendPercent(BigDecimal bundledCbsaBlendPercent) {
        this.bundledCbsaBlendPercent = bundledCbsaBlendPercent;
    }

    @Generated
    public void setCbsaPercent(BigDecimal cbsaPercent) {
        this.cbsaPercent = cbsaPercent;
    }

    @Generated
    public void setCbsaWagePaymentRate(BigDecimal cbsaWagePaymentRate) {
        this.cbsaWagePaymentRate = cbsaWagePaymentRate;
    }

    @Generated
    public void setCompositeCbsaBlendPercent(BigDecimal compositeCbsaBlendPercent) {
        this.compositeCbsaBlendPercent = compositeCbsaBlendPercent;
    }

    @Generated
    public void setDrugAddOnAmount(BigDecimal drugAddOnAmount) {
        this.drugAddOnAmount = drugAddOnAmount;
    }

    @Generated
    public void setPatientAge(Integer patientAge) {
        this.patientAge = patientAge;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentBillingData)) {
            return false;
        }
        PaymentBillingData other = (PaymentBillingData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$patientAge = this.getPatientAge();
        Integer other$patientAge = other.getPatientAge();
        if (this$patientAge == null ? other$patientAge != null : !((Object)this$patientAge).equals(other$patientAge)) {
            return false;
        }
        BigDecimal this$bundledCbsaBlendPercent = this.getBundledCbsaBlendPercent();
        BigDecimal other$bundledCbsaBlendPercent = other.getBundledCbsaBlendPercent();
        if (this$bundledCbsaBlendPercent == null ? other$bundledCbsaBlendPercent != null : !((Object)this$bundledCbsaBlendPercent).equals(other$bundledCbsaBlendPercent)) {
            return false;
        }
        BigDecimal this$cbsaPercent = this.getCbsaPercent();
        BigDecimal other$cbsaPercent = other.getCbsaPercent();
        if (this$cbsaPercent == null ? other$cbsaPercent != null : !((Object)this$cbsaPercent).equals(other$cbsaPercent)) {
            return false;
        }
        BigDecimal this$cbsaWagePaymentRate = this.getCbsaWagePaymentRate();
        BigDecimal other$cbsaWagePaymentRate = other.getCbsaWagePaymentRate();
        if (this$cbsaWagePaymentRate == null ? other$cbsaWagePaymentRate != null : !((Object)this$cbsaWagePaymentRate).equals(other$cbsaWagePaymentRate)) {
            return false;
        }
        BigDecimal this$compositeCbsaBlendPercent = this.getCompositeCbsaBlendPercent();
        BigDecimal other$compositeCbsaBlendPercent = other.getCompositeCbsaBlendPercent();
        if (this$compositeCbsaBlendPercent == null ? other$compositeCbsaBlendPercent != null : !((Object)this$compositeCbsaBlendPercent).equals(other$compositeCbsaBlendPercent)) {
            return false;
        }
        BigDecimal this$drugAddOnAmount = this.getDrugAddOnAmount();
        BigDecimal other$drugAddOnAmount = other.getDrugAddOnAmount();
        return !(this$drugAddOnAmount == null ? other$drugAddOnAmount != null : !((Object)this$drugAddOnAmount).equals(other$drugAddOnAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentBillingData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $patientAge = this.getPatientAge();
        result = result * 59 + ($patientAge == null ? 43 : ((Object)$patientAge).hashCode());
        BigDecimal $bundledCbsaBlendPercent = this.getBundledCbsaBlendPercent();
        result = result * 59 + ($bundledCbsaBlendPercent == null ? 43 : ((Object)$bundledCbsaBlendPercent).hashCode());
        BigDecimal $cbsaPercent = this.getCbsaPercent();
        result = result * 59 + ($cbsaPercent == null ? 43 : ((Object)$cbsaPercent).hashCode());
        BigDecimal $cbsaWagePaymentRate = this.getCbsaWagePaymentRate();
        result = result * 59 + ($cbsaWagePaymentRate == null ? 43 : ((Object)$cbsaWagePaymentRate).hashCode());
        BigDecimal $compositeCbsaBlendPercent = this.getCompositeCbsaBlendPercent();
        result = result * 59 + ($compositeCbsaBlendPercent == null ? 43 : ((Object)$compositeCbsaBlendPercent).hashCode());
        BigDecimal $drugAddOnAmount = this.getDrugAddOnAmount();
        result = result * 59 + ($drugAddOnAmount == null ? 43 : ((Object)$drugAddOnAmount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PaymentBillingData(bundledCbsaBlendPercent=" + this.getBundledCbsaBlendPercent() + ", cbsaPercent=" + this.getCbsaPercent() + ", cbsaWagePaymentRate=" + this.getCbsaWagePaymentRate() + ", compositeCbsaBlendPercent=" + this.getCompositeCbsaBlendPercent() + ", drugAddOnAmount=" + this.getDrugAddOnAmount() + ", patientAge=" + this.getPatientAge() + ")";
    }

    @Generated
    public PaymentBillingData() {
    }
}

