/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import org.apache.commons.lang3.Strings;

public class SetBundledAgeAdjustmentFactor
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.getPatientAge() < 13) {
            if (Strings.CS.equalsAny(claimData.getRevenueCode(), "0821", "0881")) {
                calculationContext.setBundledAgeAdjustmentFactor(calculationContext.getExpandedBundleUnder13HemodialysisModePaymentMultiplier());
            } else {
                calculationContext.setBundledAgeAdjustmentFactor(calculationContext.getExpandedBundleUnder13PeritonealDialysisModePaymentMultiplier());
            }
            return;
        }
        if (calculationContext.getPatientAge() < 18) {
            if (Strings.CS.equalsAny(claimData.getRevenueCode(), "0821", "0881")) {
                calculationContext.setBundledAgeAdjustmentFactor(calculationContext.getExpandedBundle13To17HemodialysisModePaymentMultiplier());
            } else {
                calculationContext.setBundledAgeAdjustmentFactor(calculationContext.getExpandedBundle13To17PeritonealDialysisModePaymentMultiplier());
            }
            return;
        }
        if (calculationContext.getPatientAge() < 45) {
            calculationContext.setBundledAgeAdjustmentFactor(calculationContext.getCaseMixAge18To44Multiplier());
            return;
        }
        if (calculationContext.getPatientAge() < 60) {
            calculationContext.setBundledAgeAdjustmentFactor(calculationContext.getCaseMixAge45To59Multiplier());
            return;
        }
        if (calculationContext.getPatientAge() < 70) {
            calculationContext.setBundledAgeAdjustmentFactor(calculationContext.getCaseMixAge60To69Multiplier());
            return;
        }
        if (calculationContext.getPatientAge() < 80) {
            calculationContext.setBundledAgeAdjustmentFactor(calculationContext.getCaseMixAge70To79Multiplier());
            return;
        }
        calculationContext.setBundledAgeAdjustmentFactor(calculationContext.getCaseMixAge80PlusMultiplier());
    }
}

