/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.BundledPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.PayerOnlyConditionCode;
import org.apache.commons.lang3.StringUtils;

public class SetBundledComorbiditiesAdjustment
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        BundledPaymentData bundledData = calculationContext.getBundledData();
        if (StringUtils.isEmpty(calculationContext.getCwfReturnCode())) {
            if (!calculationContext.isAdultPatient()) {
                calculationContext.setBundledComorbidityMultiplier(EsrdPricerContext.DEFAULT_MULTIPLIER);
                bundledData.setComorbidityPaymentCode("10");
            } else if (BigDecimalUtils.equals(calculationContext.getBundledOnsetFactor(), calculationContext.getCaseMixOnsetLessThanOrEqualTo120Multiplier())) {
                calculationContext.setBundledComorbidityMultiplier(EsrdPricerContext.DEFAULT_MULTIPLIER);
                bundledData.setComorbidityPaymentCode("10");
            } else {
                this.calculateComorbidityAdjustment(calculationContext);
                calculationContext.setBundledComorbidityMultiplier(calculationContext.getComorbidityMultiplier());
            }
        } else {
            switch (calculationContext.getCwfReturnCode()) {
                case "10": {
                    calculationContext.setBundledComorbidityMultiplier(EsrdPricerContext.DEFAULT_MULTIPLIER);
                    bundledData.setComorbidityPaymentCode(calculationContext.getCwfReturnCode());
                    break;
                }
                case "20": {
                    calculationContext.setBundledComorbidityMultiplier(calculationContext.getCaseMixGastrointestinalBleedMultiplier());
                    bundledData.setComorbidityPaymentCode(calculationContext.getCwfReturnCode());
                    break;
                }
                case "40": {
                    calculationContext.setBundledComorbidityMultiplier(calculationContext.getCaseMixPericarditisMultiplier());
                    bundledData.setComorbidityPaymentCode(calculationContext.getCwfReturnCode());
                    break;
                }
            }
        }
    }

    protected void calculateComorbidityAdjustment(EsrdPricerContext calculationContext) {
        BundledPaymentData bundledData = calculationContext.getBundledData();
        calculationContext.setComorbidityMultiplier(EsrdPricerContext.DEFAULT_MULTIPLIER);
        bundledData.setComorbidityPaymentCode("10");
        for (String comorbidityCode : calculationContext.getComorbidityCodes()) {
            if (null == comorbidityCode) continue;
            this.processComorbidityCode(calculationContext, bundledData, comorbidityCode);
        }
    }

    protected void processComorbidityCode(EsrdPricerContext calculationContext, BundledPaymentData bundledData, String comorbidityCode) {
        PayerOnlyConditionCode payerOnlyConditionCode = PayerOnlyConditionCode.valueOf(comorbidityCode);
        switch (payerOnlyConditionCode) {
            case MA: {
                calculationContext.setComorbidityMultiplier(calculationContext.getCaseMixGastrointestinalBleedMultiplier());
                calculationContext.setAcuteComorbidityFound(true);
                bundledData.setComorbidityPaymentCode(payerOnlyConditionCode.getReturnCode());
                break;
            }
            case MC: {
                if (!BigDecimalUtils.isGreaterThan(calculationContext.getCaseMixPericarditisMultiplier(), calculationContext.getComorbidityMultiplier())) break;
                calculationContext.setComorbidityMultiplier(calculationContext.getCaseMixPericarditisMultiplier());
                calculationContext.setAcuteComorbidityFound(true);
                bundledData.setComorbidityPaymentCode(payerOnlyConditionCode.getReturnCode());
                break;
            }
            case MD: {
                if (!BigDecimalUtils.isGreaterThan(calculationContext.getCaseMixMyelodysplasticSyndromeMultiplier(), calculationContext.getComorbidityMultiplier())) break;
                calculationContext.setComorbidityMultiplier(calculationContext.getCaseMixMyelodysplasticSyndromeMultiplier());
                calculationContext.setChronicComorbidityFound(true);
                bundledData.setComorbidityPaymentCode(payerOnlyConditionCode.getReturnCode());
                break;
            }
            case ME: {
                if (!BigDecimalUtils.isGreaterThan(calculationContext.getCaseMixSickleCellMultiplier(), calculationContext.getComorbidityMultiplier())) break;
                calculationContext.setComorbidityMultiplier(calculationContext.getCaseMixSickleCellMultiplier());
                calculationContext.setChronicComorbidityFound(true);
                bundledData.setComorbidityPaymentCode(payerOnlyConditionCode.getReturnCode());
                break;
            }
        }
    }
}

