/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors.outlier;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateSeparatelyBillableOutlierBmiFactor
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        calculationContext.setOutlierBmi(calculationContext.calculateBodyMassIndex().setScale(4, RoundingMode.HALF_UP));
        if (calculationContext.isAdultPatient() && BigDecimalUtils.isLessThan(calculationContext.getOutlierBmi(), EsrdPricerContext.BMI_CUTOFF_18_POINT_5)) {
            calculationContext.setOutlierBmiFactor(calculationContext.getSeparatelyBillableBmiUnderCutoffMultiplier().setScale(4, RoundingMode.HALF_UP));
        } else {
            calculationContext.setOutlierBmiFactor(new BigDecimal("1.0000"));
        }
    }
}

