/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors.outlier;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import org.apache.commons.lang3.Strings;

public class SetSeparatelyBillableOutlierAgeAdjustmentFactor
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.getPatientAge() < 13) {
            if (Strings.CS.equalsAny(claimData.getRevenueCode(), "0821", "0881")) {
                calculationContext.setOutlierAgeAdjustmentFactor(calculationContext.getSeparatelyBillableUnder13HemodialysisModePaymentMultiplier());
            } else {
                calculationContext.setOutlierAgeAdjustmentFactor(calculationContext.getSeparatelyBillableUnder13PeritonealDialysisModePaymentMultiplier());
            }
            return;
        }
        if (calculationContext.getPatientAge() < 18) {
            if (Strings.CS.equalsAny(claimData.getRevenueCode(), "0821", "0881")) {
                calculationContext.setOutlierAgeAdjustmentFactor(calculationContext.getSeparatelyBillable13To17HemodialysisModePaymentMultiplier());
            } else {
                calculationContext.setOutlierAgeAdjustmentFactor(calculationContext.getSeparatelyBillable13To17PeritonealDialysisModePaymentMultiplier());
            }
            return;
        }
        if (calculationContext.getPatientAge() < 45) {
            calculationContext.setOutlierAgeAdjustmentFactor(calculationContext.getSeparatelyBillableAge18To44Multiplier());
            return;
        }
        if (calculationContext.getPatientAge() < 60) {
            calculationContext.setOutlierAgeAdjustmentFactor(calculationContext.getSeparatelyBillableAge45To59Multiplier());
            return;
        }
        if (calculationContext.getPatientAge() < 70) {
            calculationContext.setOutlierAgeAdjustmentFactor(calculationContext.getSeparatelyBillableAge60To69Multiplier());
            return;
        }
        if (calculationContext.getPatientAge() < 80) {
            calculationContext.setOutlierAgeAdjustmentFactor(calculationContext.getSeparatelyBillableAge70To79Multiplier());
            return;
        }
        calculationContext.setOutlierAgeAdjustmentFactor(calculationContext.getSeparatelyBillableAge80PlusMultiplier());
    }
}

