/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2023.move_results.wage_index;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class ApplySupplementalWageIndex2023
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public boolean shouldExecute(EsrdPricerContext calculationContext) {
        return !StringUtils.equals("1", calculationContext.getProviderData().getSpecialPaymentIndicator());
    }

    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        OutpatientProviderData providerData = calculationContext.getProviderData();
        if (LocalDateUtils.isAfter(claimData.getServiceThroughDate(), LocalDate.of(2022, 12, 31)) && StringUtils.equals("1", providerData.getSupplementalWageIndexIndicator())) {
            if (BigDecimalUtils.isGreaterThanZero(providerData.getSupplementalWageIndex())) {
                BigDecimal supplementalWageIndexRatio = calculationContext.getBundledWageIndex().subtract(providerData.getSupplementalWageIndex()).divide(providerData.getSupplementalWageIndex(), RoundingMode.DOWN);
                if (BigDecimalUtils.isLessThan(supplementalWageIndexRatio, new BigDecimal("-0.05"))) {
                    calculationContext.setBundledWageIndex(providerData.getSupplementalWageIndex().multiply(new BigDecimal("0.95")).setScale(4, RoundingMode.HALF_UP));
                }
            } else {
                calculationContext.applyReturnCode(ReturnCode.CBSA_NOT_FOUND_60);
                calculationContext.setCalculationCompleted();
            }
        }
    }
}

