/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2025;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.BundledPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.Strings;

public class CalculateAkiPayment2025
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public boolean shouldExecute(EsrdPricerContext calculationContext) {
        return calculationContext.isAki84() && calculationContext.matchesReturnCode(ReturnCode.CALCULATION_STARTED_00);
    }

    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.isAkiFacility84()) {
            calculationContext.setFinalPaymentAmount(calculationContext.getBundledBaseWageAmount().setScale(2, RoundingMode.HALF_UP));
            calculationContext.applyReturnCode(ReturnCode.PAYMENT_NO_ADJUSTMENTS_02);
        }
        if (calculationContext.isAkiHome8474()) {
            calculationContext.applyReturnCode(ReturnCode.PAYMENT_NO_ADJUSTMENTS_02);
            calculationContext.setFinalPaymentAmount(calculationContext.getBundledBaseWageAmount().setScale(2, RoundingMode.HALF_UP));
            if (Strings.CS.equalsAny(claimData.getRevenueCode(), "0841", "0851")) {
                calculationContext.setFinalPaymentAmount(calculationContext.getBundledBaseWageAmount().multiply(new BigDecimal(3)).divide(new BigDecimal(7), 4, RoundingMode.DOWN));
                calculationContext.setHemoEquivalentDialysisSessions(new BigDecimal(claimData.getDialysisSessionCount()).multiply(new BigDecimal(3)).divide(new BigDecimal(7), 4, RoundingMode.HALF_UP));
            }
        } else if (calculationContext.isAkiTraining8473() || calculationContext.isAkiRetraining8487()) {
            calculationContext.setBundledWageAdjustedTrainingAmount(calculationContext.getTrainingAddOnPaymentAmount().multiply(calculationContext.getBundledWageIndex()).setScale(4, RoundingMode.HALF_UP));
            calculationContext.setTrainingClaim(true);
            calculationContext.setFinalPaymentAmount(calculationContext.getBundledBaseWageAmount().add(calculationContext.getBundledWageAdjustedTrainingAmount()).setScale(2, RoundingMode.HALF_UP));
            calculationContext.applyReturnCode(ReturnCode.TRAINING_PAYMENT_11);
        }
        BundledPaymentData bundledData = calculationContext.getBundledData();
        bundledData.setComorbidityPaymentCode("10");
    }
}

