/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2025;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.rules.rules_2022_2.bundled_factors.CalculateBundledConditionCodePayment2022Dot2;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.Strings;

public class CalculateBundledConditionCodePayment2025
extends CalculateBundledConditionCodePayment2022Dot2 {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if ((calculationContext.isEsrdTraining73() || calculationContext.isEsrdRetraining87()) && Strings.CS.equalsAny(claimData.getRevenueCode(), "0821", "0831", "0841", "0851")) {
            if (BigDecimalUtils.equals(calculationContext.getBundledOnsetFactor(), calculationContext.getCaseMixOnsetLessThanOrEqualTo120Multiplier())) {
                calculationContext.setBundledWageAdjustedTrainingAmount(BigDecimal.ZERO);
            } else {
                calculationContext.setBundledWageAdjustedTrainingAmount(calculationContext.getTrainingAddOnPaymentAmount().multiply(calculationContext.getBundledWageIndex()).setScale(4, RoundingMode.HALF_UP));
                calculationContext.setTrainingClaim(true);
            }
        } else {
            this.calculateInHomePerDiemAmount(calculationContext);
        }
    }

    @Override
    protected void calculateInHomePerDiemAmount(EsrdPricerContext calculationContext) {
        if (calculationContext.isPerDiemClaim()) {
            calculationContext.setPerDiemAmountWithoutEtc(calculationContext.getBundledAdjustedBaseWageAmount().multiply(new BigDecimal(3)).divide(new BigDecimal(7), 4, RoundingMode.DOWN));
        } else {
            calculationContext.setBundledWageAdjustedTrainingAmount(BigDecimal.ZERO);
        }
    }
}

