/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2025.bundled_factors.outliers;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateImputedOutlierSvcsMapPerTrt2025
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.isPerDiemClaim()) {
            calculationContext.setHemoEquivalentDialysisSessions(new BigDecimal(claimData.getDialysisSessionCount()).multiply(new BigDecimal(3)).divide(new BigDecimal(7), 4, RoundingMode.HALF_UP));
            calculationContext.setOutlierImputedMapAmount(claimData.getTotalPriceSeparatelyBillableOutlier().divide(calculationContext.getHemoEquivalentDialysisSessions(), 4, RoundingMode.HALF_UP));
        } else {
            calculationContext.setOutlierImputedMapAmount(claimData.getTotalPriceSeparatelyBillableOutlier().divide(new BigDecimal(claimData.getDialysisSessionCount()), 4, RoundingMode.HALF_UP));
        }
    }
}

