/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.validation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.ComorbidityData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;
import org.apache.commons.lang3.StringUtils;

public class ValidateCwfComorbidityReturnCode
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public boolean shouldExecute(EsrdPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ReturnCode.CALCULATION_STARTED_00);
    }

    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        ComorbidityData comorbidities = calculationContext.getComorbidities();
        calculationContext.setCwfReturnCode(comorbidities.getCwfReturnCode());
        if (!calculationContext.isAki84() && StringUtils.isNotEmpty(comorbidities.getCwfReturnCode()) && calculationContext.isComorbidityReturnCodeInvalid()) {
            calculationContext.applyReturnCode(ReturnCode.INVALID_COMORBID_CWF_RETURN_CODE_81);
        }
    }
}

