/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import io.dropwizard.util.Enums;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FuzzyEnumModule
extends Module {
    @Override
    public String getModuleName() {
        return "permissive-enums";
    }

    @Override
    public Version version() {
        return Version.unknownVersion();
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        context.addDeserializers(new PermissiveEnumDeserializers());
    }

    private static class PermissiveEnumDeserializers
    extends Deserializers.Base {
        private PermissiveEnumDeserializers() {
        }

        @Override
        public @Nullable JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription desc) throws JsonMappingException {
            if (config.hasDeserializationFeatures(DeserializationFeature.READ_ENUMS_USING_TO_STRING.getMask()) || config.hasDeserializationFeatures(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL.getMask()) || config.hasDeserializationFeatures(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE.getMask())) {
                return null;
            }
            List<AnnotatedMethod> factoryMethods = desc.getFactoryMethods();
            if (factoryMethods != null) {
                for (AnnotatedMethod am : factoryMethods) {
                    if (!am.hasAnnotation(JsonCreator.class)) continue;
                    return null;
                }
            }
            for (Field field : type.getFields()) {
                for (Annotation annotation : field.getAnnotations()) {
                    String packageName = annotation.annotationType().getPackage().getName();
                    if (!packageName.equals("com.fasterxml.jackson.annotation")) continue;
                    return null;
                }
            }
            return new PermissiveEnumDeserializer(type);
        }
    }

    private static class PermissiveEnumDeserializer
    extends StdScalarDeserializer<Enum<?>> {
        private static final long serialVersionUID = 1L;
        private final Enum<?>[] constants = (Enum[])this.handledType().getEnumConstants();
        private final List<String> acceptedValues = new ArrayList<String>();

        protected PermissiveEnumDeserializer(Class<Enum<?>> clazz) {
            super(clazz);
            for (Enum<?> constant : this.constants) {
                this.acceptedValues.add(constant.name());
            }
        }

        @Override
        public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Enum<?> constant = Enums.fromStringFuzzy(jp.getText(), this.constants);
            if (constant != null) {
                return constant;
            }
            throw ctxt.weirdStringException(jp.getText(), this.handledType(), jp.getText() + " was not one of " + this.acceptedValues);
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }
}

