/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import io.dropwizard.jersey.validation.FuzzyEnumParamConverter;
import io.dropwizard.jersey.validation.JerseyParameterNameProvider;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.internal.util.ReflectionHelper;

@Provider
public class FuzzyEnumParamConverterProvider
implements ParamConverterProvider {
    @Override
    public <T> @Nullable ParamConverter<T> getConverter(Class<T> rawType, @Nullable Type genericType, Annotation[] annotations) {
        if (!rawType.isEnum()) {
            return null;
        }
        Class<T> type = rawType;
        Enum[] constants = (Enum[])type.getEnumConstants();
        String parameterName = JerseyParameterNameProvider.getParameterNameFromAnnotations(annotations).orElse("Parameter");
        Method fromStringMethod = AccessController.doPrivileged(ReflectionHelper.getFromStringStringMethodPA(rawType));
        return new FuzzyEnumParamConverter<T>(rawType, fromStringMethod, constants, parameterName);
    }
}

