/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.validator.parameternameprovider.ReflectionParameterNameProvider;

public class JerseyParameterNameProvider
extends ReflectionParameterNameProvider {
    @Override
    public List<String> getParameterNames(Method method) {
        Parameter[] parameters = method.getParameters();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<String> names = new ArrayList<String>(parameterAnnotations.length);
        for (int i2 = 0; i2 < parameterAnnotations.length; ++i2) {
            Annotation[] annotations = parameterAnnotations[i2];
            String name = JerseyParameterNameProvider.getParameterNameFromAnnotations(annotations).orElse(parameters[i2].getName());
            names.add(name);
        }
        return names;
    }

    public static Optional<String> getParameterNameFromAnnotations(Annotation[] memberAnnotations) {
        for (Annotation a : memberAnnotations) {
            if (a instanceof QueryParam) {
                return Optional.of("query param " + ((QueryParam)a).value());
            }
            if (a instanceof PathParam) {
                return Optional.of("path param " + ((PathParam)a).value());
            }
            if (a instanceof HeaderParam) {
                return Optional.of("header " + ((HeaderParam)a).value());
            }
            if (a instanceof CookieParam) {
                return Optional.of("cookie " + ((CookieParam)a).value());
            }
            if (a instanceof FormParam) {
                return Optional.of("form field " + ((FormParam)a).value());
            }
            if (a instanceof Context) {
                return Optional.of("context");
            }
            if (!(a instanceof MatrixParam)) continue;
            return Optional.of("matrix param " + ((MatrixParam)a).value());
        }
        return Optional.empty();
    }
}

