/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.IntrospectionError;

public final class Introspection {
    private static final Map<MethodKey, Optional<Method>> METHOD_CACHE = new ConcurrentHashMap<MethodKey, Optional<Method>>();
    private static boolean bareNamePropertyMethods = false;

    public static Method getPropertyGetter(String propertyName, Object target) {
        Preconditions.checkNotNullOrEmpty(propertyName);
        Objects.requireNonNull(target);
        Method getter = Introspection.findGetter(propertyName, target);
        if (getter == null) {
            throw new IntrospectionError(Introspection.propertyNotFoundErrorMessage("No getter for property %s in %s", propertyName, target));
        }
        if (!Modifier.isPublic(getter.getModifiers())) {
            throw new IntrospectionError(Introspection.propertyNotFoundErrorMessage("No public getter for property %s in %s", propertyName, target));
        }
        try {
            getter.setAccessible(true);
            getter.invoke(target, new Object[0]);
        }
        catch (Exception t2) {
            throw new IntrospectionError(Introspection.propertyNotFoundErrorMessage("Unable to find property %s in %s", propertyName, target), t2);
        }
        return getter;
    }

    public static void setExtractBareNamePropertyMethods(boolean barenamePropertyMethods) {
        ConfigurationProvider.loadRegisteredConfiguration();
        bareNamePropertyMethods = barenamePropertyMethods;
    }

    @VisibleForTesting
    public static boolean canExtractBareNamePropertyMethods() {
        return bareNamePropertyMethods;
    }

    private static String propertyNotFoundErrorMessage(String message, String propertyName, Object target) {
        String targetTypeName = target.getClass().getName();
        String property = Strings.quote(propertyName);
        return String.format(message, property, targetTypeName);
    }

    private static Method findGetter(String propertyName, Object target) {
        String capitalized = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method getter = Introspection.findMethod("get" + capitalized, target);
        if (Introspection.isValidGetter(getter)) {
            return getter;
        }
        if (bareNamePropertyMethods && Introspection.isValidGetter(getter = Introspection.findMethod(propertyName, target))) {
            return getter;
        }
        Method isAccessor = Introspection.findMethod("is" + capitalized, target);
        return Introspection.isValidGetter(isAccessor) ? isAccessor : null;
    }

    private static boolean isValidGetter(Method method) {
        return method != null && !Modifier.isStatic(method.getModifiers()) && !Void.TYPE.equals(method.getReturnType());
    }

    private static Method findMethod(String name, Object target) {
        MethodKey methodKey = new MethodKey(name, target.getClass());
        return METHOD_CACHE.computeIfAbsent(methodKey, Introspection::findMethodByKey).orElse(null);
    }

    private static Optional<Method> findMethodByKey(MethodKey key) {
        Class clazz = key.clazz;
        try {
            return Optional.of(clazz.getMethod(key.name, new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            while (clazz != null) {
                try {
                    return Optional.of(clazz.getDeclaredMethod(key.name, new Class[0]));
                }
                catch (NoSuchMethodException | SecurityException exception2) {
                    clazz = clazz.getSuperclass();
                }
            }
            return Optional.empty();
        }
    }

    private Introspection() {
    }

    private static final class MethodKey {
        private final String name;
        private final Class<?> clazz;

        private MethodKey(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            return Objects.equals(this.name, methodKey.name) && Objects.equals(this.clazz, methodKey.clazz);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.clazz);
        }
    }
}

