/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.annotation.Annotation;
import java.util.function.Function;
import org.junit.jupiter.api.condition.AbstractJreCondition;
import org.junit.jupiter.api.condition.BooleanExecutionCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.platform.commons.util.Preconditions;

abstract class AbstractJreRangeCondition<A extends Annotation>
extends BooleanExecutionCondition<A> {
    private final String annotationName;

    AbstractJreRangeCondition(Class<A> annotationType, Function<A, String> customDisabledReason) {
        super(annotationType, AbstractJreCondition.ENABLED_ON_CURRENT_JRE, AbstractJreCondition.DISABLED_ON_CURRENT_JRE, customDisabledReason);
        this.annotationName = annotationType.getSimpleName();
    }

    protected final boolean isCurrentVersionWithinRange(JRE minJre, JRE maxJre, int minVersion, int maxVersion) {
        boolean minJreSet = minJre != JRE.UNDEFINED;
        boolean maxJreSet = maxJre != JRE.UNDEFINED;
        boolean minVersionSet = minVersion != -1;
        boolean maxVersionSet = maxVersion != -1;
        Preconditions.condition(!minJreSet || !minVersionSet, () -> String.format("@%s's minimum value must be configured with either a JRE enum constant or numeric version, but not both", this.annotationName));
        Preconditions.condition(!maxJreSet || !maxVersionSet, () -> String.format("@%s's maximum value must be configured with either a JRE enum constant or numeric version, but not both", this.annotationName));
        Preconditions.condition(!minVersionSet || minVersion >= 8, () -> String.format("@%s's minVersion [%d] must be greater than or equal to %d", this.annotationName, minVersion, 8));
        Preconditions.condition(!maxVersionSet || maxVersion >= 8, () -> String.format("@%s's maxVersion [%d] must be greater than or equal to %d", this.annotationName, maxVersion, 8));
        if (!minJreSet) {
            minJre = JRE.JAVA_8;
        }
        if (!maxJreSet) {
            maxJre = JRE.OTHER;
        }
        int min2 = minVersionSet ? minVersion : minJre.version();
        int max = maxVersionSet ? maxVersion : maxJre.version();
        Preconditions.condition(min2 != 8 || max != Integer.MAX_VALUE, () -> "You must declare a non-default value for the minimum or maximum value in @" + this.annotationName);
        Preconditions.condition(min2 >= 8, () -> String.format("@%s's minimum value [%d] must greater than or equal to %d", this.annotationName, min2, 8));
        Preconditions.condition(min2 <= max, () -> String.format("@%s's minimum value [%d] must be less than or equal to its maximum value [%d]", this.annotationName, min2, max));
        return JRE.isCurrentVersionWithinRange(min2, max);
    }
}

