/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.PreInterruptCallback;
import org.junit.jupiter.api.extension.PreInterruptContext;

final class PreInterruptThreadDumpPrinter
implements PreInterruptCallback {
    private static final String NL = "\n";

    PreInterruptThreadDumpPrinter() {
    }

    @Override
    public void beforeThreadInterrupt(PreInterruptContext preInterruptContext, ExtensionContext extensionContext) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder();
        sb.append("Thread ");
        this.appendThreadName(sb, preInterruptContext.getThreadToInterrupt());
        sb.append(" will be interrupted.");
        sb.append(NL);
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] stack = entry.getValue();
            if (stack.length <= 0) continue;
            sb.append(NL);
            this.appendThreadName(sb, thread);
            for (StackTraceElement stackTraceElement : stack) {
                sb.append(NL);
                sb.append("\tat ");
                sb.append(stackTraceElement.toString());
            }
            sb.append(NL);
        }
        System.out.println(sb);
    }

    private void appendThreadName(StringBuilder sb, Thread th) {
        sb.append("\"");
        sb.append(th.getName());
        sb.append("\"");
        if (th.isDaemon()) {
            sb.append(" daemon");
        }
        sb.append(" prio=");
        sb.append(th.getPriority());
        sb.append(" Id=");
        sb.append(th.getId());
        sb.append(" ");
        sb.append((Object)th.getState());
    }
}

