// Generated by delombok at Thu Dec 04 18:36:34 UTC 2025
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

@Schema(description = "The payment billing information for display; separate from the claim pricing result.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-DATA-TEST", value = "<structure>")})})
public class PaymentBillingData {
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The bundled core-based statistical area (CBSA) blend percent.", example = "0.75", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BUN-CBSA-PCT-BLEND", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal bundledCbsaBlendPercent;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The core-based statistical area (CBSA) percentage factor (as compared to the " + "metropolitan statistical area (MSA) percentage).", example = "0.63", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "CBSA-PCT", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal cbsaPercent;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999.99")
  @Digits(integer = 4, fraction = 2)
  @Schema(description = "The core-based statistical area (CBSA) wage payment rate.", example = "3265.44", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "CBSA-WAGE-PMT-RATE", value = "PIC 9(04)V9(02)")})})
  @FixedValue
  private BigDecimal cbsaWagePaymentRate;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The composite core-based statistical area (CBSA) blend percent.", example = "0.20", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "COM-CBSA-PCT-BLEND", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal compositeCbsaBlendPercent;
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "The drug add-on amount.", example = "8.3305", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRUG-ADD-ON-RETURN", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal drugAddOnAmount;
  @Max(999)
  @Min(0)
  @NotNull
  @Schema(description = "The patient age for the purposes of claim pricing.", example = "27", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "AGE-RETURN", value = "PIC 9(03)")})})
  private Integer patientAge = 0;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledCbsaBlendPercent() {
    return this.bundledCbsaBlendPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCbsaPercent() {
    return this.cbsaPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCbsaWagePaymentRate() {
    return this.cbsaWagePaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCompositeCbsaBlendPercent() {
    return this.compositeCbsaBlendPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDrugAddOnAmount() {
    return this.drugAddOnAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getPatientAge() {
    return this.patientAge;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledCbsaBlendPercent(final BigDecimal bundledCbsaBlendPercent) {
    this.bundledCbsaBlendPercent = bundledCbsaBlendPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCbsaPercent(final BigDecimal cbsaPercent) {
    this.cbsaPercent = cbsaPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCbsaWagePaymentRate(final BigDecimal cbsaWagePaymentRate) {
    this.cbsaWagePaymentRate = cbsaWagePaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCompositeCbsaBlendPercent(final BigDecimal compositeCbsaBlendPercent) {
    this.compositeCbsaBlendPercent = compositeCbsaBlendPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDrugAddOnAmount(final BigDecimal drugAddOnAmount) {
    this.drugAddOnAmount = drugAddOnAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientAge(final Integer patientAge) {
    this.patientAge = patientAge;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof PaymentBillingData)) return false;
    final PaymentBillingData other = (PaymentBillingData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$patientAge = this.getPatientAge();
    final java.lang.Object other$patientAge = other.getPatientAge();
    if (this$patientAge == null ? other$patientAge != null : !this$patientAge.equals(other$patientAge)) return false;
    final java.lang.Object this$bundledCbsaBlendPercent = this.getBundledCbsaBlendPercent();
    final java.lang.Object other$bundledCbsaBlendPercent = other.getBundledCbsaBlendPercent();
    if (this$bundledCbsaBlendPercent == null ? other$bundledCbsaBlendPercent != null : !this$bundledCbsaBlendPercent.equals(other$bundledCbsaBlendPercent)) return false;
    final java.lang.Object this$cbsaPercent = this.getCbsaPercent();
    final java.lang.Object other$cbsaPercent = other.getCbsaPercent();
    if (this$cbsaPercent == null ? other$cbsaPercent != null : !this$cbsaPercent.equals(other$cbsaPercent)) return false;
    final java.lang.Object this$cbsaWagePaymentRate = this.getCbsaWagePaymentRate();
    final java.lang.Object other$cbsaWagePaymentRate = other.getCbsaWagePaymentRate();
    if (this$cbsaWagePaymentRate == null ? other$cbsaWagePaymentRate != null : !this$cbsaWagePaymentRate.equals(other$cbsaWagePaymentRate)) return false;
    final java.lang.Object this$compositeCbsaBlendPercent = this.getCompositeCbsaBlendPercent();
    final java.lang.Object other$compositeCbsaBlendPercent = other.getCompositeCbsaBlendPercent();
    if (this$compositeCbsaBlendPercent == null ? other$compositeCbsaBlendPercent != null : !this$compositeCbsaBlendPercent.equals(other$compositeCbsaBlendPercent)) return false;
    final java.lang.Object this$drugAddOnAmount = this.getDrugAddOnAmount();
    final java.lang.Object other$drugAddOnAmount = other.getDrugAddOnAmount();
    if (this$drugAddOnAmount == null ? other$drugAddOnAmount != null : !this$drugAddOnAmount.equals(other$drugAddOnAmount)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof PaymentBillingData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $patientAge = this.getPatientAge();
    result = result * PRIME + ($patientAge == null ? 43 : $patientAge.hashCode());
    final java.lang.Object $bundledCbsaBlendPercent = this.getBundledCbsaBlendPercent();
    result = result * PRIME + ($bundledCbsaBlendPercent == null ? 43 : $bundledCbsaBlendPercent.hashCode());
    final java.lang.Object $cbsaPercent = this.getCbsaPercent();
    result = result * PRIME + ($cbsaPercent == null ? 43 : $cbsaPercent.hashCode());
    final java.lang.Object $cbsaWagePaymentRate = this.getCbsaWagePaymentRate();
    result = result * PRIME + ($cbsaWagePaymentRate == null ? 43 : $cbsaWagePaymentRate.hashCode());
    final java.lang.Object $compositeCbsaBlendPercent = this.getCompositeCbsaBlendPercent();
    result = result * PRIME + ($compositeCbsaBlendPercent == null ? 43 : $compositeCbsaBlendPercent.hashCode());
    final java.lang.Object $drugAddOnAmount = this.getDrugAddOnAmount();
    result = result * PRIME + ($drugAddOnAmount == null ? 43 : $drugAddOnAmount.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "PaymentBillingData(bundledCbsaBlendPercent=" + this.getBundledCbsaBlendPercent() + ", cbsaPercent=" + this.getCbsaPercent() + ", cbsaWagePaymentRate=" + this.getCbsaWagePaymentRate() + ", compositeCbsaBlendPercent=" + this.getCompositeCbsaBlendPercent() + ", drugAddOnAmount=" + this.getDrugAddOnAmount() + ", patientAge=" + this.getPatientAge() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentBillingData() {
  }
}
