// Generated by delombok at Tue Dec 09 21:36:13 UTC 2025
package gov.cms.fiss.pricers.fqhc.core;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.daily.DailyRates;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;
import gov.cms.fiss.pricers.fqhc.core.tables.DataTables;
import java.math.BigDecimal;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ServiceLineContext extends CalculationContext<IoceServiceLineData, ServiceLinePaymentData> {
  // Medicare Advantage claim revenue code
  public static final String REV_CODE_MA_CLAIM = "0519";
  // The Maryland Primary Care Program (MDPCP) claims are claims
  // that have 052x on the first three digits of the Revenue code.
  public static final String REV_CODE_PREFIX = "052";

  public boolean isValidRevenueCode() {
    return getInput().getRevenueCode().startsWith(REV_CODE_PREFIX);
  }

  // Line item action flags
  public static final String LI_ACTION_NON_COVERED = "5";
  // Line Item Deny Reject Flags
  private static final String[] LI_NOT_DENY_REJECT = new String[] {"0", "3"};
  // Payment indicators (PI)
  public static final String PI_PAID_GFTF = "14";
  // NEW FOR 2024
  public static final String PI_IOP_SERVICE_15 = "15";
  // NEW FOR 2024
  public static final String PI_MA_SERVICE_IOP_WRAP_AROUND_16 = "16";
  public static final String PI_PAID_WITH_ADD_ON = "13";
  public static final String PI_NO_ADDITIONAL_PAYMENT = "12";
  public static final String PI_NOT_PAID = "11";
  public static final String PI_PAID_ENCOUNTER = "10";
  public static final String PI_TELEHEALTH = "2";
  // Package flags
  public static final String PACKAGE_NONE = "0";
  public static final String PACKAGE_ENCOUNTER = "5";
  public static final String PACKAGE_PREVENTIVE = "6";
  // Compensation adjustment line types
  public static final String LINE_OTHER = "00";
  public static final String LINE_MEDICAL = "01";
  public static final String LINE_MENTAL = "02";
  public static final String LINE_MOD59 = "03";
  public static final String LINE_IOP_LTE3 = "04";
  public static final String LINE_IOP_GTE4 = "05";
  // Payment Method Flags
  private static final String[] PPS_PAYMENT_FLAGS = {"5", "Z"};
  private static final String[] COINSURANCE_NA_PAYMENT_FLAGS = {"C", "V"};
  // Added PI = '15' & '16' to Paid Line PI Flag List for 2024
  private static final String[] PAID_LINE = new String[] {PI_PAID_ENCOUNTER, PI_PAID_WITH_ADD_ON, PI_PAID_GFTF, PI_IOP_SERVICE_15, PI_MA_SERVICE_IOP_WRAP_AROUND_16};
  private static final String[] VALID_INDICATORS = new String[] {PI_PAID_ENCOUNTER, PI_PAID_WITH_ADD_ON, PI_PAID_GFTF, PI_NO_ADDITIONAL_PAYMENT, PI_NOT_PAID, PI_TELEHEALTH, PI_IOP_SERVICE_15, PI_MA_SERVICE_IOP_WRAP_AROUND_16};
  private static final String[] PACKAGE_FLAGS = new String[] {PACKAGE_NONE, PACKAGE_ENCOUNTER, PACKAGE_PREVENTIVE};
  // ADDED NEW COMPOSITE ADJUSTMENT FLAG = '4' FOR 2024
  private static final String[] VALID_LINE_TYPES = new String[] {LINE_OTHER, LINE_MEDICAL, LINE_MENTAL, LINE_MOD59, LINE_IOP_LTE3, LINE_IOP_GTE4};
  private final FqhcPricerContext fqhcPricerContext;
  @FixedValue
  private BigDecimal ppsRate = BigDecimalUtils.ZERO;
  @FixedValue
  private DailyRates dailyRates;
  private BigDecimal unreducedPayment = BigDecimalUtils.ZERO;

  public ServiceLineContext(IoceServiceLineData input, ServiceLinePaymentData output, FqhcPricerContext fqhcPricerContext) {
    super(input, output);
    this.fqhcPricerContext = fqhcPricerContext;
    initializeContext();
  }

  private void initializeContext() {
    final ReturnCodeData returnCodeData = new ReturnCodeData();
    returnCodeData.setCode("00");
    returnCodeData.setDescription("No description available");
    getOutput().setReturnCodeData(returnCodeData);
  }

  // Calculation data
  public static boolean isInvalidLineType(String lineType) {
    return !StringUtils.equalsAny(lineType, VALID_LINE_TYPES);
  }

  public static boolean isInvalidPackageFlag(String packageFlag) {
    return !StringUtils.equalsAny(packageFlag, PACKAGE_FLAGS);
  }

  public static boolean isInvalidPaymentIndicator(String paymentIndicator) {
    return !StringUtils.equalsAny(paymentIndicator, VALID_INDICATORS);
  }

  public static boolean isPaidLine(String paymentIndicator) {
    return StringUtils.equalsAny(paymentIndicator, PAID_LINE);
  }

  public boolean isNotDenyOrRejectFlag() {
    return StringUtils.equalsAny(getInput().getDenyOrRejectFlag(), LI_NOT_DENY_REJECT);
  }

  // Access to per-line request/response content
  public boolean isCoinsuranceNAPaymentFlag() {
    return StringUtils.equalsAny(getInput().getPaymentMethodFlag(), COINSURANCE_NA_PAYMENT_FLAGS);
  }

  // Access to static data
  public static String[] getPpsPaymentFlags() {
    return ArrayUtils.clone(PPS_PAYMENT_FLAGS);
  }

  /**
   * Checks the payment method flag against the two sets of valid flags.
   *
   * @return boolean The validity of the payment method flag.
   */
  public boolean isNotValidPaymentMethodFlag() {
    // add all is used to merge 2 arrays
    return !StringUtils.equalsAny(getInput().getPaymentMethodFlag(), ArrayUtils.addAll(COINSURANCE_NA_PAYMENT_FLAGS, PPS_PAYMENT_FLAGS));
  }

  public void completeWithReturnCode(ReturnCode returnCode) {
    applyReturnCode(returnCode);
    setCalculationCompleted();
  }

  public void applyReturnCode(ReturnCode returnCode) {
    getOutput().setReturnCodeData(returnCode.toReturnCodeData());
  }

  public DataTables getDataTables() {
    return fqhcPricerContext.getDataTables(getInput().getDateOfService());
  }

  // Manage state
  public DaySummary getDaySummary() {
    return fqhcPricerContext.getDaySummary(getInput().getDateOfService());
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FqhcPricerContext getFqhcPricerContext() {
    return this.fqhcPricerContext;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPpsRate() {
    return this.ppsRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPpsRate(final BigDecimal ppsRate) {
    this.ppsRate = ppsRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DailyRates getDailyRates() {
    return this.dailyRates;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDailyRates(final DailyRates dailyRates) {
    this.dailyRates = dailyRates;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getUnreducedPayment() {
    return this.unreducedPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUnreducedPayment(final BigDecimal unreducedPayment) {
    this.unreducedPayment = unreducedPayment;
  }
}
