// Generated by delombok at Tue Dec 09 21:36:13 UTC 2025
package gov.cms.fiss.pricers.fqhc.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;

/**
 * Creates the lookup table needed for CBSA per-year data.
 */
public class PaymentRateTableEntryLookupGenerator {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(PaymentRateTableEntryLookupGenerator.class);
  private final CsvContentReader<PaymentRateTableEntry> contentProvider = new CsvContentReader<>(PaymentRateTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

  public PaymentRateTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
    if (!csvIngestionConfiguration.isValidationEnabled()) {
      contentProvider.disableValidation();
    }
  }

  /**
   * Generates the lookup cross-reference from the specified source.
   *
   * @param csvFilename the file to process
   * @return the generated lookup
   */
  public NavigableMap<LocalDate, BigDecimal> generate(String csvFilename) {
    final List<PaymentRateTableEntry> content = contentProvider.read(csvFilename);
    return LookupGenerator.generateMap(PaymentRateTableEntry::getEffectiveDate, PaymentRateTableEntry::getRateValue, content, TreeMap::new);
  }
}
